const PUBLIC_RPC_ENDPOINTS = [
  "https://api.zan.top/node/v1/solana/mainnet/71ee6fc7bd674be7b96a2007fe9de581"
];
const DEXSCREENER_BASE = "https://api.dexscreener.com";
const PUMPFUN_PROGRAM_ID = "6EF8rrecthR5Dkzon8Nwu78hRvfCKubJ14M5uBEwF6P";
const ANALYSIS_THRESHOLDS = {
  // 缓存时间（毫秒）
  CACHE_TTL: 24 * 60 * 60 * 1e3
  // 24小时
};
const COLORS = {
  // 评分颜色
  gradeA: "#22c55e",
  gradeB: "#84cc16",
  gradeC: "#eab308",
  gradeD: "#f97316",
  gradeF: "#ef4444",
  // 标签颜色
  labelSerious: "#22c55e",
  labelFarmer: "#eab308",
  labelFactory: "#ef4444",
  labelNewbie: "#6b7280",
  labelModerate: "#3b82f6"
};
const LABEL_COLORS = {
  "认真开发": COLORS.labelSerious,
  "高频农夫": COLORS.labelFarmer,
  "地毯工厂": COLORS.labelFactory,
  "新号/数据不足": COLORS.labelNewbie,
  "中等活跃": COLORS.labelModerate
};
const GRADE_COLORS = {
  "A": COLORS.gradeA,
  "B": COLORS.gradeB,
  "C": COLORS.gradeC,
  "D": COLORS.gradeD,
  "F": COLORS.gradeF
};
function shortenAddress(address, chars = 4) {
  if (!address) return "";
  return `${address.slice(0, chars)}...${address.slice(-chars)}`;
}
function formatUSD(amount) {
  if (amount >= 1e6) {
    return "$" + (amount / 1e6).toFixed(2) + "M";
  }
  if (amount >= 1e3) {
    return "$" + (amount / 1e3).toFixed(2) + "K";
  }
  return "$" + amount.toFixed(2);
}
function formatPercent(ratio) {
  return (ratio * 100).toFixed(1) + "%";
}
function formatRelativeTime(timestamp) {
  const now = Date.now();
  const diff = now - timestamp;
  const minutes = Math.floor(diff / 6e4);
  const hours = Math.floor(diff / 36e5);
  const days = Math.floor(diff / 864e5);
  if (minutes < 1) return "刚刚";
  if (minutes < 60) return `${minutes} 分钟前`;
  if (hours < 24) return `${hours} 小时前`;
  if (days < 30) return `${days} 天前`;
  return new Date(timestamp).toLocaleDateString("zh-CN");
}
function formatDuration(ms) {
  const seconds = Math.floor(ms / 1e3);
  const minutes = Math.floor(seconds / 60);
  const hours = Math.floor(minutes / 60);
  const days = Math.floor(hours / 24);
  if (days > 0) {
    return `${days} 天 ${hours % 24} 小时`;
  }
  if (hours > 0) {
    return `${hours} 小时 ${minutes % 60} 分钟`;
  }
  if (minutes > 0) {
    return `${minutes} 分钟`;
  }
  return `${seconds} 秒`;
}
function sleep(ms) {
  return new Promise((resolve) => setTimeout(resolve, ms));
}
async function retry(fn, maxRetries = 3, delay = 1e3) {
  let lastError = null;
  for (let i = 0; i < maxRetries; i++) {
    try {
      return await fn();
    } catch (error) {
      lastError = error;
      if (i < maxRetries - 1) {
        await sleep(delay * (i + 1));
      }
    }
  }
  throw lastError;
}
function isValidSolanaAddress(address) {
  const base58Regex = /^[1-9A-HJ-NP-Za-km-z]{32,44}$/;
  return base58Regex.test(address);
}
export {
  ANALYSIS_THRESHOLDS as A,
  DEXSCREENER_BASE as D,
  GRADE_COLORS as G,
  LABEL_COLORS as L,
  PUBLIC_RPC_ENDPOINTS as P,
  PUMPFUN_PROGRAM_ID as a,
  shortenAddress as b,
  formatPercent as c,
  formatUSD as d,
  formatDuration as e,
  formatRelativeTime as f,
  isValidSolanaAddress as i,
  retry as r,
  sleep as s
};
