import { G as GRADE_COLORS, L as LABEL_COLORS, b as shortenAddress, f as formatRelativeTime, c as formatPercent, d as formatUSD, e as formatDuration, i as isValidSolanaAddress } from "./chunks/utils.C3mUlwWA.js";
const DEFAULT_CONFIG = {
  maxTokensToAnalyze: 50,
  cacheExpiry: 24,
  autoShow: true,
  compactMode: false,
  rugRatioWarningThreshold: 0.3,
  bundleWalletWarningThreshold: 3
};
(function polyfill() {
  const relList = document.createElement("link").relList;
  if (relList && relList.supports && relList.supports("modulepreload")) {
    return;
  }
  for (const link of document.querySelectorAll('link[rel="modulepreload"]')) {
    processPreload(link);
  }
  new MutationObserver((mutations) => {
    for (const mutation of mutations) {
      if (mutation.type !== "childList") {
        continue;
      }
      for (const node of mutation.addedNodes) {
        if (node.tagName === "LINK" && node.rel === "modulepreload")
          processPreload(node);
      }
    }
  }).observe(document, { childList: true, subtree: true });
  function getFetchOpts(link) {
    const fetchOpts = {};
    if (link.integrity) fetchOpts.integrity = link.integrity;
    if (link.referrerPolicy) fetchOpts.referrerPolicy = link.referrerPolicy;
    if (link.crossOrigin === "use-credentials")
      fetchOpts.credentials = "include";
    else if (link.crossOrigin === "anonymous") fetchOpts.credentials = "omit";
    else fetchOpts.credentials = "same-origin";
    return fetchOpts;
  }
  function processPreload(link) {
    if (link.ep)
      return;
    link.ep = true;
    const fetchOpts = getFetchOpts(link);
    fetch(link.href, fetchOpts);
  }
})();
var n, l$1, u$2, i$1, o$1, r$1, e$1, f$2, c$1, s$1, a$1, p$1 = {}, v$1 = [], y$1 = /acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i, d$1 = Array.isArray;
function w$1(n2, l2) {
  for (var u2 in l2) n2[u2] = l2[u2];
  return n2;
}
function g(n2) {
  n2 && n2.parentNode && n2.parentNode.removeChild(n2);
}
function _(l2, u2, t2) {
  var i2, o2, r2, e2 = {};
  for (r2 in u2) "key" == r2 ? i2 = u2[r2] : "ref" == r2 ? o2 = u2[r2] : e2[r2] = u2[r2];
  if (arguments.length > 2 && (e2.children = arguments.length > 3 ? n.call(arguments, 2) : t2), "function" == typeof l2 && null != l2.defaultProps) for (r2 in l2.defaultProps) void 0 === e2[r2] && (e2[r2] = l2.defaultProps[r2]);
  return m$1(l2, e2, i2, o2, null);
}
function m$1(n2, t2, i2, o2, r2) {
  var e2 = { type: n2, props: t2, key: i2, ref: o2, __k: null, __: null, __b: 0, __e: null, __c: null, constructor: void 0, __v: null == r2 ? ++u$2 : r2, __i: -1, __u: 0 };
  return null == r2 && null != l$1.vnode && l$1.vnode(e2), e2;
}
function k$1(n2) {
  return n2.children;
}
function x(n2, l2) {
  this.props = n2, this.context = l2;
}
function S(n2, l2) {
  if (null == l2) return n2.__ ? S(n2.__, n2.__i + 1) : null;
  for (var u2; l2 < n2.__k.length; l2++) if (null != (u2 = n2.__k[l2]) && null != u2.__e) return u2.__e;
  return "function" == typeof n2.type ? S(n2) : null;
}
function C$1(n2) {
  var l2, u2;
  if (null != (n2 = n2.__) && null != n2.__c) {
    for (n2.__e = n2.__c.base = null, l2 = 0; l2 < n2.__k.length; l2++) if (null != (u2 = n2.__k[l2]) && null != u2.__e) {
      n2.__e = n2.__c.base = u2.__e;
      break;
    }
    return C$1(n2);
  }
}
function M(n2) {
  (!n2.__d && (n2.__d = true) && i$1.push(n2) && !$.__r++ || o$1 != l$1.debounceRendering) && ((o$1 = l$1.debounceRendering) || r$1)($);
}
function $() {
  for (var n2, u2, t2, o2, r2, f2, c2, s2 = 1; i$1.length; ) i$1.length > s2 && i$1.sort(e$1), n2 = i$1.shift(), s2 = i$1.length, n2.__d && (t2 = void 0, o2 = void 0, r2 = (o2 = (u2 = n2).__v).__e, f2 = [], c2 = [], u2.__P && ((t2 = w$1({}, o2)).__v = o2.__v + 1, l$1.vnode && l$1.vnode(t2), O(u2.__P, t2, o2, u2.__n, u2.__P.namespaceURI, 32 & o2.__u ? [r2] : null, f2, null == r2 ? S(o2) : r2, !!(32 & o2.__u), c2), t2.__v = o2.__v, t2.__.__k[t2.__i] = t2, N(f2, t2, c2), o2.__e = o2.__ = null, t2.__e != r2 && C$1(t2)));
  $.__r = 0;
}
function I(n2, l2, u2, t2, i2, o2, r2, e2, f2, c2, s2) {
  var a2, h2, y2, d2, w2, g2, _2, m2 = t2 && t2.__k || v$1, b = l2.length;
  for (f2 = P(u2, l2, m2, f2, b), a2 = 0; a2 < b; a2++) null != (y2 = u2.__k[a2]) && (h2 = -1 == y2.__i ? p$1 : m2[y2.__i] || p$1, y2.__i = a2, g2 = O(n2, y2, h2, i2, o2, r2, e2, f2, c2, s2), d2 = y2.__e, y2.ref && h2.ref != y2.ref && (h2.ref && B$1(h2.ref, null, y2), s2.push(y2.ref, y2.__c || d2, y2)), null == w2 && null != d2 && (w2 = d2), (_2 = !!(4 & y2.__u)) || h2.__k === y2.__k ? f2 = A(y2, f2, n2, _2) : "function" == typeof y2.type && void 0 !== g2 ? f2 = g2 : d2 && (f2 = d2.nextSibling), y2.__u &= -7);
  return u2.__e = w2, f2;
}
function P(n2, l2, u2, t2, i2) {
  var o2, r2, e2, f2, c2, s2 = u2.length, a2 = s2, h2 = 0;
  for (n2.__k = new Array(i2), o2 = 0; o2 < i2; o2++) null != (r2 = l2[o2]) && "boolean" != typeof r2 && "function" != typeof r2 ? ("string" == typeof r2 || "number" == typeof r2 || "bigint" == typeof r2 || r2.constructor == String ? r2 = n2.__k[o2] = m$1(null, r2, null, null, null) : d$1(r2) ? r2 = n2.__k[o2] = m$1(k$1, { children: r2 }, null, null, null) : void 0 === r2.constructor && r2.__b > 0 ? r2 = n2.__k[o2] = m$1(r2.type, r2.props, r2.key, r2.ref ? r2.ref : null, r2.__v) : n2.__k[o2] = r2, f2 = o2 + h2, r2.__ = n2, r2.__b = n2.__b + 1, e2 = null, -1 != (c2 = r2.__i = L(r2, u2, f2, a2)) && (a2--, (e2 = u2[c2]) && (e2.__u |= 2)), null == e2 || null == e2.__v ? (-1 == c2 && (i2 > s2 ? h2-- : i2 < s2 && h2++), "function" != typeof r2.type && (r2.__u |= 4)) : c2 != f2 && (c2 == f2 - 1 ? h2-- : c2 == f2 + 1 ? h2++ : (c2 > f2 ? h2-- : h2++, r2.__u |= 4))) : n2.__k[o2] = null;
  if (a2) for (o2 = 0; o2 < s2; o2++) null != (e2 = u2[o2]) && 0 == (2 & e2.__u) && (e2.__e == t2 && (t2 = S(e2)), D$1(e2, e2));
  return t2;
}
function A(n2, l2, u2, t2) {
  var i2, o2;
  if ("function" == typeof n2.type) {
    for (i2 = n2.__k, o2 = 0; i2 && o2 < i2.length; o2++) i2[o2] && (i2[o2].__ = n2, l2 = A(i2[o2], l2, u2, t2));
    return l2;
  }
  n2.__e != l2 && (t2 && (l2 && n2.type && !l2.parentNode && (l2 = S(n2)), u2.insertBefore(n2.__e, l2 || null)), l2 = n2.__e);
  do {
    l2 = l2 && l2.nextSibling;
  } while (null != l2 && 8 == l2.nodeType);
  return l2;
}
function L(n2, l2, u2, t2) {
  var i2, o2, r2, e2 = n2.key, f2 = n2.type, c2 = l2[u2], s2 = null != c2 && 0 == (2 & c2.__u);
  if (null === c2 && null == e2 || s2 && e2 == c2.key && f2 == c2.type) return u2;
  if (t2 > (s2 ? 1 : 0)) {
    for (i2 = u2 - 1, o2 = u2 + 1; i2 >= 0 || o2 < l2.length; ) if (null != (c2 = l2[r2 = i2 >= 0 ? i2-- : o2++]) && 0 == (2 & c2.__u) && e2 == c2.key && f2 == c2.type) return r2;
  }
  return -1;
}
function T$1(n2, l2, u2) {
  "-" == l2[0] ? n2.setProperty(l2, null == u2 ? "" : u2) : n2[l2] = null == u2 ? "" : "number" != typeof u2 || y$1.test(l2) ? u2 : u2 + "px";
}
function j$1(n2, l2, u2, t2, i2) {
  var o2, r2;
  n: if ("style" == l2) if ("string" == typeof u2) n2.style.cssText = u2;
  else {
    if ("string" == typeof t2 && (n2.style.cssText = t2 = ""), t2) for (l2 in t2) u2 && l2 in u2 || T$1(n2.style, l2, "");
    if (u2) for (l2 in u2) t2 && u2[l2] == t2[l2] || T$1(n2.style, l2, u2[l2]);
  }
  else if ("o" == l2[0] && "n" == l2[1]) o2 = l2 != (l2 = l2.replace(f$2, "$1")), r2 = l2.toLowerCase(), l2 = r2 in n2 || "onFocusOut" == l2 || "onFocusIn" == l2 ? r2.slice(2) : l2.slice(2), n2.l || (n2.l = {}), n2.l[l2 + o2] = u2, u2 ? t2 ? u2.u = t2.u : (u2.u = c$1, n2.addEventListener(l2, o2 ? a$1 : s$1, o2)) : n2.removeEventListener(l2, o2 ? a$1 : s$1, o2);
  else {
    if ("http://www.w3.org/2000/svg" == i2) l2 = l2.replace(/xlink(H|:h)/, "h").replace(/sName$/, "s");
    else if ("width" != l2 && "height" != l2 && "href" != l2 && "list" != l2 && "form" != l2 && "tabIndex" != l2 && "download" != l2 && "rowSpan" != l2 && "colSpan" != l2 && "role" != l2 && "popover" != l2 && l2 in n2) try {
      n2[l2] = null == u2 ? "" : u2;
      break n;
    } catch (n3) {
    }
    "function" == typeof u2 || (null == u2 || false === u2 && "-" != l2[4] ? n2.removeAttribute(l2) : n2.setAttribute(l2, "popover" == l2 && 1 == u2 ? "" : u2));
  }
}
function F(n2) {
  return function(u2) {
    if (this.l) {
      var t2 = this.l[u2.type + n2];
      if (null == u2.t) u2.t = c$1++;
      else if (u2.t < t2.u) return;
      return t2(l$1.event ? l$1.event(u2) : u2);
    }
  };
}
function O(n2, u2, t2, i2, o2, r2, e2, f2, c2, s2) {
  var a2, h2, p2, v2, y2, _2, m2, b, S2, C2, M2, $2, P2, A2, H, L2, T2, j2 = u2.type;
  if (void 0 !== u2.constructor) return null;
  128 & t2.__u && (c2 = !!(32 & t2.__u), r2 = [f2 = u2.__e = t2.__e]), (a2 = l$1.__b) && a2(u2);
  n: if ("function" == typeof j2) try {
    if (b = u2.props, S2 = "prototype" in j2 && j2.prototype.render, C2 = (a2 = j2.contextType) && i2[a2.__c], M2 = a2 ? C2 ? C2.props.value : a2.__ : i2, t2.__c ? m2 = (h2 = u2.__c = t2.__c).__ = h2.__E : (S2 ? u2.__c = h2 = new j2(b, M2) : (u2.__c = h2 = new x(b, M2), h2.constructor = j2, h2.render = E), C2 && C2.sub(h2), h2.state || (h2.state = {}), h2.__n = i2, p2 = h2.__d = true, h2.__h = [], h2._sb = []), S2 && null == h2.__s && (h2.__s = h2.state), S2 && null != j2.getDerivedStateFromProps && (h2.__s == h2.state && (h2.__s = w$1({}, h2.__s)), w$1(h2.__s, j2.getDerivedStateFromProps(b, h2.__s))), v2 = h2.props, y2 = h2.state, h2.__v = u2, p2) S2 && null == j2.getDerivedStateFromProps && null != h2.componentWillMount && h2.componentWillMount(), S2 && null != h2.componentDidMount && h2.__h.push(h2.componentDidMount);
    else {
      if (S2 && null == j2.getDerivedStateFromProps && b !== v2 && null != h2.componentWillReceiveProps && h2.componentWillReceiveProps(b, M2), u2.__v == t2.__v || !h2.__e && null != h2.shouldComponentUpdate && false === h2.shouldComponentUpdate(b, h2.__s, M2)) {
        for (u2.__v != t2.__v && (h2.props = b, h2.state = h2.__s, h2.__d = false), u2.__e = t2.__e, u2.__k = t2.__k, u2.__k.some(function(n3) {
          n3 && (n3.__ = u2);
        }), $2 = 0; $2 < h2._sb.length; $2++) h2.__h.push(h2._sb[$2]);
        h2._sb = [], h2.__h.length && e2.push(h2);
        break n;
      }
      null != h2.componentWillUpdate && h2.componentWillUpdate(b, h2.__s, M2), S2 && null != h2.componentDidUpdate && h2.__h.push(function() {
        h2.componentDidUpdate(v2, y2, _2);
      });
    }
    if (h2.context = M2, h2.props = b, h2.__P = n2, h2.__e = false, P2 = l$1.__r, A2 = 0, S2) {
      for (h2.state = h2.__s, h2.__d = false, P2 && P2(u2), a2 = h2.render(h2.props, h2.state, h2.context), H = 0; H < h2._sb.length; H++) h2.__h.push(h2._sb[H]);
      h2._sb = [];
    } else do {
      h2.__d = false, P2 && P2(u2), a2 = h2.render(h2.props, h2.state, h2.context), h2.state = h2.__s;
    } while (h2.__d && ++A2 < 25);
    h2.state = h2.__s, null != h2.getChildContext && (i2 = w$1(w$1({}, i2), h2.getChildContext())), S2 && !p2 && null != h2.getSnapshotBeforeUpdate && (_2 = h2.getSnapshotBeforeUpdate(v2, y2)), L2 = a2, null != a2 && a2.type === k$1 && null == a2.key && (L2 = V(a2.props.children)), f2 = I(n2, d$1(L2) ? L2 : [L2], u2, t2, i2, o2, r2, e2, f2, c2, s2), h2.base = u2.__e, u2.__u &= -161, h2.__h.length && e2.push(h2), m2 && (h2.__E = h2.__ = null);
  } catch (n3) {
    if (u2.__v = null, c2 || null != r2) if (n3.then) {
      for (u2.__u |= c2 ? 160 : 128; f2 && 8 == f2.nodeType && f2.nextSibling; ) f2 = f2.nextSibling;
      r2[r2.indexOf(f2)] = null, u2.__e = f2;
    } else {
      for (T2 = r2.length; T2--; ) g(r2[T2]);
      z$1(u2);
    }
    else u2.__e = t2.__e, u2.__k = t2.__k, n3.then || z$1(u2);
    l$1.__e(n3, u2, t2);
  }
  else null == r2 && u2.__v == t2.__v ? (u2.__k = t2.__k, u2.__e = t2.__e) : f2 = u2.__e = q$1(t2.__e, u2, t2, i2, o2, r2, e2, c2, s2);
  return (a2 = l$1.diffed) && a2(u2), 128 & u2.__u ? void 0 : f2;
}
function z$1(n2) {
  n2 && n2.__c && (n2.__c.__e = true), n2 && n2.__k && n2.__k.forEach(z$1);
}
function N(n2, u2, t2) {
  for (var i2 = 0; i2 < t2.length; i2++) B$1(t2[i2], t2[++i2], t2[++i2]);
  l$1.__c && l$1.__c(u2, n2), n2.some(function(u3) {
    try {
      n2 = u3.__h, u3.__h = [], n2.some(function(n3) {
        n3.call(u3);
      });
    } catch (n3) {
      l$1.__e(n3, u3.__v);
    }
  });
}
function V(n2) {
  return "object" != typeof n2 || null == n2 || n2.__b && n2.__b > 0 ? n2 : d$1(n2) ? n2.map(V) : w$1({}, n2);
}
function q$1(u2, t2, i2, o2, r2, e2, f2, c2, s2) {
  var a2, h2, v2, y2, w2, _2, m2, b = i2.props || p$1, k2 = t2.props, x2 = t2.type;
  if ("svg" == x2 ? r2 = "http://www.w3.org/2000/svg" : "math" == x2 ? r2 = "http://www.w3.org/1998/Math/MathML" : r2 || (r2 = "http://www.w3.org/1999/xhtml"), null != e2) {
    for (a2 = 0; a2 < e2.length; a2++) if ((w2 = e2[a2]) && "setAttribute" in w2 == !!x2 && (x2 ? w2.localName == x2 : 3 == w2.nodeType)) {
      u2 = w2, e2[a2] = null;
      break;
    }
  }
  if (null == u2) {
    if (null == x2) return document.createTextNode(k2);
    u2 = document.createElementNS(r2, x2, k2.is && k2), c2 && (l$1.__m && l$1.__m(t2, e2), c2 = false), e2 = null;
  }
  if (null == x2) b === k2 || c2 && u2.data == k2 || (u2.data = k2);
  else {
    if (e2 = e2 && n.call(u2.childNodes), !c2 && null != e2) for (b = {}, a2 = 0; a2 < u2.attributes.length; a2++) b[(w2 = u2.attributes[a2]).name] = w2.value;
    for (a2 in b) if (w2 = b[a2], "children" == a2) ;
    else if ("dangerouslySetInnerHTML" == a2) v2 = w2;
    else if (!(a2 in k2)) {
      if ("value" == a2 && "defaultValue" in k2 || "checked" == a2 && "defaultChecked" in k2) continue;
      j$1(u2, a2, null, w2, r2);
    }
    for (a2 in k2) w2 = k2[a2], "children" == a2 ? y2 = w2 : "dangerouslySetInnerHTML" == a2 ? h2 = w2 : "value" == a2 ? _2 = w2 : "checked" == a2 ? m2 = w2 : c2 && "function" != typeof w2 || b[a2] === w2 || j$1(u2, a2, w2, b[a2], r2);
    if (h2) c2 || v2 && (h2.__html == v2.__html || h2.__html == u2.innerHTML) || (u2.innerHTML = h2.__html), t2.__k = [];
    else if (v2 && (u2.innerHTML = ""), I("template" == t2.type ? u2.content : u2, d$1(y2) ? y2 : [y2], t2, i2, o2, "foreignObject" == x2 ? "http://www.w3.org/1999/xhtml" : r2, e2, f2, e2 ? e2[0] : i2.__k && S(i2, 0), c2, s2), null != e2) for (a2 = e2.length; a2--; ) g(e2[a2]);
    c2 || (a2 = "value", "progress" == x2 && null == _2 ? u2.removeAttribute("value") : null != _2 && (_2 !== u2[a2] || "progress" == x2 && !_2 || "option" == x2 && _2 != b[a2]) && j$1(u2, a2, _2, b[a2], r2), a2 = "checked", null != m2 && m2 != u2[a2] && j$1(u2, a2, m2, b[a2], r2));
  }
  return u2;
}
function B$1(n2, u2, t2) {
  try {
    if ("function" == typeof n2) {
      var i2 = "function" == typeof n2.__u;
      i2 && n2.__u(), i2 && null == u2 || (n2.__u = n2(u2));
    } else n2.current = u2;
  } catch (n3) {
    l$1.__e(n3, t2);
  }
}
function D$1(n2, u2, t2) {
  var i2, o2;
  if (l$1.unmount && l$1.unmount(n2), (i2 = n2.ref) && (i2.current && i2.current != n2.__e || B$1(i2, null, u2)), null != (i2 = n2.__c)) {
    if (i2.componentWillUnmount) try {
      i2.componentWillUnmount();
    } catch (n3) {
      l$1.__e(n3, u2);
    }
    i2.base = i2.__P = null;
  }
  if (i2 = n2.__k) for (o2 = 0; o2 < i2.length; o2++) i2[o2] && D$1(i2[o2], u2, t2 || "function" != typeof n2.type);
  t2 || g(n2.__e), n2.__c = n2.__ = n2.__e = void 0;
}
function E(n2, l2, u2) {
  return this.constructor(n2, u2);
}
function G(u2, t2, i2) {
  var o2, r2, e2, f2;
  t2 == document && (t2 = document.documentElement), l$1.__ && l$1.__(u2, t2), r2 = (o2 = false) ? null : t2.__k, e2 = [], f2 = [], O(t2, u2 = t2.__k = _(k$1, null, [u2]), r2 || p$1, p$1, t2.namespaceURI, r2 ? null : t2.firstChild ? n.call(t2.childNodes) : null, e2, r2 ? r2.__e : t2.firstChild, o2, f2), N(e2, u2, f2);
}
n = v$1.slice, l$1 = { __e: function(n2, l2, u2, t2) {
  for (var i2, o2, r2; l2 = l2.__; ) if ((i2 = l2.__c) && !i2.__) try {
    if ((o2 = i2.constructor) && null != o2.getDerivedStateFromError && (i2.setState(o2.getDerivedStateFromError(n2)), r2 = i2.__d), null != i2.componentDidCatch && (i2.componentDidCatch(n2, t2 || {}), r2 = i2.__d), r2) return i2.__E = i2;
  } catch (l3) {
    n2 = l3;
  }
  throw n2;
} }, u$2 = 0, x.prototype.setState = function(n2, l2) {
  var u2;
  u2 = null != this.__s && this.__s != this.state ? this.__s : this.__s = w$1({}, this.state), "function" == typeof n2 && (n2 = n2(w$1({}, u2), this.props)), n2 && w$1(u2, n2), null != n2 && this.__v && (l2 && this._sb.push(l2), M(this));
}, x.prototype.forceUpdate = function(n2) {
  this.__v && (this.__e = true, n2 && this.__h.push(n2), M(this));
}, x.prototype.render = k$1, i$1 = [], r$1 = "function" == typeof Promise ? Promise.prototype.then.bind(Promise.resolve()) : setTimeout, e$1 = function(n2, l2) {
  return n2.__v.__b - l2.__v.__b;
}, $.__r = 0, f$2 = /(PointerCapture)$|Capture$/i, c$1 = 0, s$1 = F(false), a$1 = F(true);
var f$1 = 0;
function u$1(e2, t2, n2, o2, i2, u2) {
  t2 || (t2 = {});
  var a2, c2, p2 = t2;
  if ("ref" in p2) for (c2 in p2 = {}, t2) "ref" == c2 ? a2 = t2[c2] : p2[c2] = t2[c2];
  var l2 = { type: e2, props: p2, key: n2, ref: a2, __k: null, __: null, __b: 0, __e: null, __c: null, constructor: void 0, __v: --f$1, __i: -1, __u: 0, __source: i2, __self: u2 };
  if ("function" == typeof e2 && (a2 = e2.defaultProps)) for (c2 in a2) void 0 === p2[c2] && (p2[c2] = a2[c2]);
  return l$1.vnode && l$1.vnode(l2), l2;
}
var t, r, u, i, o = 0, f = [], c = l$1, e = c.__b, a = c.__r, v = c.diffed, l = c.__c, m = c.unmount, s = c.__;
function p(n2, t2) {
  c.__h && c.__h(r, n2, o || t2), o = 0;
  var u2 = r.__H || (r.__H = { __: [], __h: [] });
  return n2 >= u2.__.length && u2.__.push({}), u2.__[n2];
}
function d(n2) {
  return o = 1, h(D, n2);
}
function h(n2, u2, i2) {
  var o2 = p(t++, 2);
  if (o2.t = n2, !o2.__c && (o2.__ = [D(void 0, u2), function(n3) {
    var t2 = o2.__N ? o2.__N[0] : o2.__[0], r2 = o2.t(t2, n3);
    t2 !== r2 && (o2.__N = [r2, o2.__[1]], o2.__c.setState({}));
  }], o2.__c = r, !r.__f)) {
    var f2 = function(n3, t2, r2) {
      if (!o2.__c.__H) return true;
      var u3 = o2.__c.__H.__.filter(function(n4) {
        return !!n4.__c;
      });
      if (u3.every(function(n4) {
        return !n4.__N;
      })) return !c2 || c2.call(this, n3, t2, r2);
      var i3 = o2.__c.props !== n3;
      return u3.forEach(function(n4) {
        if (n4.__N) {
          var t3 = n4.__[0];
          n4.__ = n4.__N, n4.__N = void 0, t3 !== n4.__[0] && (i3 = true);
        }
      }), c2 && c2.call(this, n3, t2, r2) || i3;
    };
    r.__f = true;
    var c2 = r.shouldComponentUpdate, e2 = r.componentWillUpdate;
    r.componentWillUpdate = function(n3, t2, r2) {
      if (this.__e) {
        var u3 = c2;
        c2 = void 0, f2(n3, t2, r2), c2 = u3;
      }
      e2 && e2.call(this, n3, t2, r2);
    }, r.shouldComponentUpdate = f2;
  }
  return o2.__N || o2.__;
}
function y(n2, u2) {
  var i2 = p(t++, 3);
  !c.__s && C(i2.__H, u2) && (i2.__ = n2, i2.u = u2, r.__H.__h.push(i2));
}
function T(n2, r2) {
  var u2 = p(t++, 7);
  return C(u2.__H, r2) && (u2.__ = n2(), u2.__H = r2, u2.__h = n2), u2.__;
}
function q(n2, t2) {
  return o = 8, T(function() {
    return n2;
  }, t2);
}
function j() {
  for (var n2; n2 = f.shift(); ) if (n2.__P && n2.__H) try {
    n2.__H.__h.forEach(z), n2.__H.__h.forEach(B), n2.__H.__h = [];
  } catch (t2) {
    n2.__H.__h = [], c.__e(t2, n2.__v);
  }
}
c.__b = function(n2) {
  r = null, e && e(n2);
}, c.__ = function(n2, t2) {
  n2 && t2.__k && t2.__k.__m && (n2.__m = t2.__k.__m), s && s(n2, t2);
}, c.__r = function(n2) {
  a && a(n2), t = 0;
  var i2 = (r = n2.__c).__H;
  i2 && (u === r ? (i2.__h = [], r.__h = [], i2.__.forEach(function(n3) {
    n3.__N && (n3.__ = n3.__N), n3.u = n3.__N = void 0;
  })) : (i2.__h.forEach(z), i2.__h.forEach(B), i2.__h = [], t = 0)), u = r;
}, c.diffed = function(n2) {
  v && v(n2);
  var t2 = n2.__c;
  t2 && t2.__H && (t2.__H.__h.length && (1 !== f.push(t2) && i === c.requestAnimationFrame || ((i = c.requestAnimationFrame) || w)(j)), t2.__H.__.forEach(function(n3) {
    n3.u && (n3.__H = n3.u), n3.u = void 0;
  })), u = r = null;
}, c.__c = function(n2, t2) {
  t2.some(function(n3) {
    try {
      n3.__h.forEach(z), n3.__h = n3.__h.filter(function(n4) {
        return !n4.__ || B(n4);
      });
    } catch (r2) {
      t2.some(function(n4) {
        n4.__h && (n4.__h = []);
      }), t2 = [], c.__e(r2, n3.__v);
    }
  }), l && l(n2, t2);
}, c.unmount = function(n2) {
  m && m(n2);
  var t2, r2 = n2.__c;
  r2 && r2.__H && (r2.__H.__.forEach(function(n3) {
    try {
      z(n3);
    } catch (n4) {
      t2 = n4;
    }
  }), r2.__H = void 0, t2 && c.__e(t2, r2.__v));
};
var k = "function" == typeof requestAnimationFrame;
function w(n2) {
  var t2, r2 = function() {
    clearTimeout(u2), k && cancelAnimationFrame(t2), setTimeout(n2);
  }, u2 = setTimeout(r2, 35);
  k && (t2 = requestAnimationFrame(r2));
}
function z(n2) {
  var t2 = r, u2 = n2.__c;
  "function" == typeof u2 && (n2.__c = void 0, u2()), r = t2;
}
function B(n2) {
  var t2 = r;
  n2.__c = n2.__(), r = t2;
}
function C(n2, t2) {
  return !n2 || n2.length !== t2.length || t2.some(function(t3, r2) {
    return t3 !== n2[r2];
  });
}
function D(n2, t2) {
  return "function" == typeof t2 ? t2(n2) : t2;
}
function Header({ onManualInput, onRefresh, onClearCache, onShowHistory, onShowSettings, isLoading }) {
  const [showMenu, setShowMenu] = d(false);
  return /* @__PURE__ */ u$1("header", { className: "header", children: [
    /* @__PURE__ */ u$1("div", { className: "header-title", children: [
      /* @__PURE__ */ u$1("img", { src: "/assets/icon48.png", alt: "扒皮喵", className: "logo-img" }),
      /* @__PURE__ */ u$1("div", { className: "title-text", children: [
        /* @__PURE__ */ u$1("h1", { children: "扒皮喵" }),
        /* @__PURE__ */ u$1("p", { children: "Dev 照妖镜" })
      ] })
    ] }),
    /* @__PURE__ */ u$1("div", { className: "header-actions", children: [
      /* @__PURE__ */ u$1(
        "button",
        {
          className: "btn btn-icon",
          onClick: onManualInput,
          title: "手动输入地址",
          children: /* @__PURE__ */ u$1("svg", { width: "18", height: "18", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
            /* @__PURE__ */ u$1("path", { d: "M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7" }),
            /* @__PURE__ */ u$1("path", { d: "M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z" })
          ] })
        }
      ),
      /* @__PURE__ */ u$1(
        "button",
        {
          className: "btn btn-icon",
          onClick: onRefresh,
          disabled: isLoading,
          title: "刷新分析",
          children: /* @__PURE__ */ u$1(
            "svg",
            {
              width: "18",
              height: "18",
              viewBox: "0 0 24 24",
              fill: "none",
              stroke: "currentColor",
              strokeWidth: "2",
              className: isLoading ? "spin" : "",
              children: [
                /* @__PURE__ */ u$1("path", { d: "M23 4v6h-6" }),
                /* @__PURE__ */ u$1("path", { d: "M1 20v-6h6" }),
                /* @__PURE__ */ u$1("path", { d: "M3.51 9a9 9 0 0 1 14.85-3.36L23 10M1 14l4.64 4.36A9 9 0 0 0 20.49 15" })
              ]
            }
          )
        }
      ),
      /* @__PURE__ */ u$1("div", { className: "header-menu-wrapper", children: [
        /* @__PURE__ */ u$1(
          "button",
          {
            className: "btn btn-icon",
            onClick: () => setShowMenu(!showMenu),
            title: "更多选项",
            children: /* @__PURE__ */ u$1("svg", { width: "18", height: "18", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
              /* @__PURE__ */ u$1("circle", { cx: "12", cy: "12", r: "1" }),
              /* @__PURE__ */ u$1("circle", { cx: "12", cy: "5", r: "1" }),
              /* @__PURE__ */ u$1("circle", { cx: "12", cy: "19", r: "1" })
            ] })
          }
        ),
        showMenu && /* @__PURE__ */ u$1("div", { className: "header-dropdown", children: [
          /* @__PURE__ */ u$1("button", { className: "dropdown-item", onClick: () => {
            onShowHistory();
            setShowMenu(false);
          }, children: [
            /* @__PURE__ */ u$1("svg", { width: "16", height: "16", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
              /* @__PURE__ */ u$1("circle", { cx: "12", cy: "12", r: "10" }),
              /* @__PURE__ */ u$1("polyline", { points: "12 6 12 12 16 14" })
            ] }),
            "历史记录"
          ] }),
          /* @__PURE__ */ u$1("button", { className: "dropdown-item", onClick: () => {
            onShowSettings();
            setShowMenu(false);
          }, children: [
            /* @__PURE__ */ u$1("svg", { width: "16", height: "16", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
              /* @__PURE__ */ u$1("circle", { cx: "12", cy: "12", r: "3" }),
              /* @__PURE__ */ u$1("path", { d: "M12 1v6m0 6v10M4.22 4.22l4.24 4.24m7.08 7.08l4.24 4.24M1 12h6m6 0h10M4.22 19.78l4.24-4.24m7.08-7.08l4.24-4.24" })
            ] }),
            "设置"
          ] }),
          /* @__PURE__ */ u$1("div", { className: "dropdown-divider" }),
          /* @__PURE__ */ u$1("button", { className: "dropdown-item danger", onClick: () => {
            onClearCache();
            setShowMenu(false);
          }, children: [
            /* @__PURE__ */ u$1("svg", { width: "16", height: "16", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
              /* @__PURE__ */ u$1("polyline", { points: "3 6 5 6 21 6" }),
              /* @__PURE__ */ u$1("path", { d: "M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2" })
            ] }),
            "清除缓存"
          ] })
        ] })
      ] })
    ] })
  ] });
}
function getScoreExplanation(score) {
  const explanations = [];
  const tokenCount = score.breakdown.tokenCount.value;
  const rugRatio = score.breakdown.rugRatio.value;
  const dexRate = score.breakdown.dexSuccessRate.value;
  const bundleCount = score.breakdown.bundleWalletCount.value;
  if (tokenCount < 3) {
    explanations.push("⚠️ 发币数少于 3 个，数据不足以做出准确判断，评分已降权处理");
  }
  if (score.overall >= 80) {
    explanations.push("✅ 综合评分优秀，历史表现较好");
  } else if (score.overall >= 60) {
    explanations.push("📊 综合评分良好，建议关注风险指标");
  } else if (score.overall >= 40) {
    explanations.push("⚠️ 综合评分一般，存在一定风险");
  } else {
    explanations.push("🚨 综合评分较低，风险较高请谨慎");
  }
  const rugPercent = Math.round(rugRatio * 100);
  if (rugPercent === 0 && tokenCount >= 3) {
    explanations.push("✅ 暂无疑似 Rug 记录");
  } else if (rugPercent > 50) {
    explanations.push(`🚨 疑似 Rug 率 ${rugPercent}%，历史记录较差`);
  } else if (rugPercent > 30) {
    explanations.push(`⚠️ 疑似 Rug 率 ${rugPercent}%，需要警惕`);
  } else if (rugPercent > 0) {
    explanations.push(`📊 疑似 Rug 率 ${rugPercent}%`);
  }
  const dexPercent = Math.round(dexRate * 100);
  if (dexPercent >= 50 && tokenCount >= 3) {
    explanations.push(`✅ 外盘成功率 ${dexPercent}%，有成功案例`);
  } else if (dexPercent > 0 && dexPercent < 30) {
    explanations.push(`📊 外盘成功率 ${dexPercent}%，成功率偏低`);
  }
  if (bundleCount > 3) {
    explanations.push(`🚨 发现 ${bundleCount} 个疑似捆绑钱包，可能存在协同操作`);
  } else if (bundleCount > 0) {
    explanations.push(`⚠️ 发现 ${bundleCount} 个疑似捆绑钱包`);
  }
  if (tokenCount > 30) {
    explanations.push(`🚨 发币数 ${tokenCount} 个，属于高频发币者（工厂级别）`);
  } else if (tokenCount > 15) {
    explanations.push(`⚠️ 发币数 ${tokenCount} 个，发币频率较高`);
  }
  return explanations;
}
function ScoreCard({ devAddress, score, analyzedAt, error }) {
  const [showExplanation, setShowExplanation] = d(false);
  const gradeColor = GRADE_COLORS[score.grade] || "#6b7280";
  const labelColor = LABEL_COLORS[score.label] || "#6b7280";
  const explanations = getScoreExplanation(score);
  const copyAddress = () => {
    navigator.clipboard.writeText(devAddress);
  };
  return /* @__PURE__ */ u$1("div", { className: "score-card", children: [
    error && /* @__PURE__ */ u$1("div", { className: "error-banner", children: [
      /* @__PURE__ */ u$1("svg", { width: "16", height: "16", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
        /* @__PURE__ */ u$1("circle", { cx: "12", cy: "12", r: "10" }),
        /* @__PURE__ */ u$1("line", { x1: "12", y1: "8", x2: "12", y2: "12" }),
        /* @__PURE__ */ u$1("line", { x1: "12", y1: "16", x2: "12.01", y2: "16" })
      ] }),
      /* @__PURE__ */ u$1("span", { children: error })
    ] }),
    /* @__PURE__ */ u$1("div", { className: "dev-address", onClick: copyAddress, title: "点击复制完整地址", children: [
      /* @__PURE__ */ u$1("span", { className: "address-text", children: shortenAddress(devAddress, 6) }),
      /* @__PURE__ */ u$1("svg", { width: "14", height: "14", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
        /* @__PURE__ */ u$1("rect", { x: "9", y: "9", width: "13", height: "13", rx: "2", ry: "2" }),
        /* @__PURE__ */ u$1("path", { d: "M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1" })
      ] })
    ] }),
    /* @__PURE__ */ u$1("div", { className: "score-display", children: [
      /* @__PURE__ */ u$1("div", { className: "score-circle", style: { borderColor: gradeColor }, children: [
        /* @__PURE__ */ u$1("span", { className: "score-value", style: { color: gradeColor }, children: score.overall }),
        /* @__PURE__ */ u$1("span", { className: "score-max", children: "/100" })
      ] }),
      /* @__PURE__ */ u$1("div", { className: "score-info", children: [
        /* @__PURE__ */ u$1("div", { className: "grade-badge", style: { backgroundColor: gradeColor }, children: [
          score.grade,
          " 级"
        ] }),
        /* @__PURE__ */ u$1("div", { className: "label-badge", style: { backgroundColor: labelColor }, children: score.label })
      ] })
    ] }),
    /* @__PURE__ */ u$1("div", { className: "score-breakdown", children: [
      /* @__PURE__ */ u$1(
        BreakdownItem,
        {
          label: "发币数量",
          value: score.breakdown.tokenCount.value.toString(),
          score: score.breakdown.tokenCount.score
        }
      ),
      /* @__PURE__ */ u$1(
        BreakdownItem,
        {
          label: "Rug 率",
          value: `${Math.round(score.breakdown.rugRatio.value * 100)}%`,
          score: score.breakdown.rugRatio.score
        }
      ),
      /* @__PURE__ */ u$1(
        BreakdownItem,
        {
          label: "外盘成功率",
          value: `${Math.round(score.breakdown.dexSuccessRate.value * 100)}%`,
          score: score.breakdown.dexSuccessRate.score
        }
      ),
      /* @__PURE__ */ u$1(
        BreakdownItem,
        {
          label: "捆绑钱包",
          value: score.breakdown.bundleWalletCount.value.toString(),
          score: score.breakdown.bundleWalletCount.score
        }
      )
    ] }),
    /* @__PURE__ */ u$1("div", { className: "score-explanation-toggle", onClick: () => setShowExplanation(!showExplanation), children: [
      /* @__PURE__ */ u$1("span", { children: showExplanation ? "收起解释" : "查看评分解释" }),
      /* @__PURE__ */ u$1(
        "svg",
        {
          width: "12",
          height: "12",
          viewBox: "0 0 24 24",
          fill: "none",
          stroke: "currentColor",
          strokeWidth: "2",
          style: { transform: showExplanation ? "rotate(180deg)" : "rotate(0deg)", transition: "transform 0.2s" },
          children: /* @__PURE__ */ u$1("polyline", { points: "6 9 12 15 18 9" })
        }
      )
    ] }),
    showExplanation && /* @__PURE__ */ u$1("div", { className: "score-explanation", children: explanations.map((text, i2) => /* @__PURE__ */ u$1("div", { className: "explanation-item", children: text }, i2)) }),
    /* @__PURE__ */ u$1("div", { className: "update-time", children: [
      "数据更新于 ",
      formatRelativeTime(analyzedAt)
    ] })
  ] });
}
function BreakdownItem({ label, value, score }) {
  const getScoreColor = (s2) => {
    if (s2 >= 80) return "#22c55e";
    if (s2 >= 60) return "#84cc16";
    if (s2 >= 40) return "#eab308";
    if (s2 >= 20) return "#f97316";
    return "#ef4444";
  };
  return /* @__PURE__ */ u$1("div", { className: "breakdown-item", children: [
    /* @__PURE__ */ u$1("div", { className: "breakdown-label", children: label }),
    /* @__PURE__ */ u$1("div", { className: "breakdown-value", children: value }),
    /* @__PURE__ */ u$1("div", { className: "breakdown-bar", children: /* @__PURE__ */ u$1(
      "div",
      {
        className: "breakdown-fill",
        style: {
          width: `${score}%`,
          backgroundColor: getScoreColor(score)
        }
      }
    ) })
  ] });
}
function findWorstRug(rugTokens) {
  if (rugTokens.length === 0) return null;
  const sorted = [...rugTokens].sort((a2, b) => {
    const timeA = a2.survivalTime || Infinity;
    const timeB = b.survivalTime || Infinity;
    return timeA - timeB;
  });
  return sorted[0];
}
function StatsSection({ cluster, rugAnalysis, dexAnalysis }) {
  var _a;
  const stats = [
    {
      label: "发币总数",
      value: cluster.tokensCreated.length.toString(),
      icon: /* @__PURE__ */ u$1("svg", { width: "20", height: "20", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
        /* @__PURE__ */ u$1("circle", { cx: "12", cy: "12", r: "10" }),
        /* @__PURE__ */ u$1("path", { d: "M12 6v6l4 2" })
      ] }),
      color: "#3b82f6"
    },
    {
      label: "疑似 Rug",
      value: `${rugAnalysis.suspectedRugCount} 次`,
      subValue: formatPercent(rugAnalysis.rugRatio),
      icon: /* @__PURE__ */ u$1("svg", { width: "20", height: "20", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
        /* @__PURE__ */ u$1("path", { d: "M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z" }),
        /* @__PURE__ */ u$1("line", { x1: "12", y1: "9", x2: "12", y2: "13" }),
        /* @__PURE__ */ u$1("line", { x1: "12", y1: "17", x2: "12.01", y2: "17" })
      ] }),
      color: rugAnalysis.rugRatio > 0.3 ? "#ef4444" : "#eab308"
    },
    {
      label: "上外盘数",
      value: `${dexAnalysis.listedCount} 个`,
      subValue: formatPercent(dexAnalysis.successRate),
      icon: /* @__PURE__ */ u$1("svg", { width: "20", height: "20", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: /* @__PURE__ */ u$1("polyline", { points: "22 12 18 12 15 21 9 3 6 12 2 12" }) }),
      color: "#22c55e"
    },
    {
      label: "捆绑钱包",
      value: `${cluster.bundleWallets.length} 个`,
      icon: /* @__PURE__ */ u$1("svg", { width: "20", height: "20", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
        /* @__PURE__ */ u$1("path", { d: "M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2" }),
        /* @__PURE__ */ u$1("circle", { cx: "9", cy: "7", r: "4" }),
        /* @__PURE__ */ u$1("path", { d: "M23 21v-2a4 4 0 0 0-3-3.87" }),
        /* @__PURE__ */ u$1("path", { d: "M16 3.13a4 4 0 0 1 0 7.75" })
      ] }),
      color: cluster.bundleWallets.length > 3 ? "#f97316" : "#6b7280"
    }
  ];
  return /* @__PURE__ */ u$1("div", { className: "stats-section", children: [
    /* @__PURE__ */ u$1("h2", { className: "section-title", children: "关键数据" }),
    /* @__PURE__ */ u$1("div", { className: "stats-grid", children: stats.map((stat, index) => /* @__PURE__ */ u$1("div", { className: "stat-card", children: [
      /* @__PURE__ */ u$1("div", { className: "stat-icon", style: { color: stat.color }, children: stat.icon }),
      /* @__PURE__ */ u$1("div", { className: "stat-content", children: [
        /* @__PURE__ */ u$1("div", { className: "stat-value", children: stat.value }),
        stat.subValue && /* @__PURE__ */ u$1("div", { className: "stat-subvalue", children: [
          "(",
          stat.subValue,
          ")"
        ] }),
        /* @__PURE__ */ u$1("div", { className: "stat-label", children: stat.label })
      ] })
    ] }, index)) }),
    dexAnalysis.bestPerformer && /* @__PURE__ */ u$1("div", { className: "best-performer", children: [
      /* @__PURE__ */ u$1("h3", { children: "最佳表现" }),
      /* @__PURE__ */ u$1("div", { className: "performer-info", children: [
        /* @__PURE__ */ u$1("span", { className: "performer-mint", children: ((_a = dexAnalysis.bestPerformer.pairs[0]) == null ? void 0 : _a.baseToken.symbol) || "未知" }),
        /* @__PURE__ */ u$1("span", { className: "performer-fdv", children: [
          "最高市值 ",
          formatUSD(dexAnalysis.bestPerformer.maxFdv)
        ] })
      ] })
    ] }),
    rugAnalysis.rugTokens.length > 0 && (() => {
      const worstRug = findWorstRug(rugAnalysis.rugTokens);
      if (!worstRug) return null;
      return /* @__PURE__ */ u$1("div", { className: "worst-rug", children: [
        /* @__PURE__ */ u$1("h3", { children: "最快跑路案例" }),
        /* @__PURE__ */ u$1("div", { className: "worst-rug-info", children: [
          /* @__PURE__ */ u$1("span", { className: "worst-rug-name", children: worstRug.name || "未知代币" }),
          /* @__PURE__ */ u$1("span", { className: "worst-rug-time", children: worstRug.survivalTime ? `${formatDuration(worstRug.survivalTime)} 后归零` : "已弃置" })
        ] }),
        worstRug.evidence.length > 0 && /* @__PURE__ */ u$1("div", { className: "worst-rug-evidence", children: worstRug.evidence.slice(0, 2).map((e2, i2) => /* @__PURE__ */ u$1("span", { className: "evidence-tag", children: e2 }, i2)) })
      ] });
    })()
  ] });
}
function TokenList({ tokens, rugTokens, dexTokens }) {
  const [filter, setFilter] = d("all");
  const [expanded, setExpanded] = d(null);
  const rugMap = new Map(rugTokens.map((r2) => [r2.mint, r2]));
  const dexMap = new Map(dexTokens.map((d2) => [d2.mint, d2]));
  const filteredTokens = tokens.filter((token) => {
    const isRugged = rugMap.has(token.mint);
    const dexInfo = dexMap.get(token.mint);
    const isListed = (dexInfo == null ? void 0 : dexInfo.isListed) || false;
    switch (filter) {
      case "rugged":
        return isRugged;
      case "listed":
        return isListed;
      case "abandoned":
        return !isListed && !isRugged;
      default:
        return true;
    }
  });
  const filterOptions = [
    { key: "all", label: "全部" },
    { key: "rugged", label: "疑似Rug" },
    { key: "listed", label: "已上外盘" },
    { key: "abandoned", label: "未上外盘" }
  ];
  return /* @__PURE__ */ u$1("div", { className: "token-list-section", children: [
    /* @__PURE__ */ u$1("div", { className: "section-header", children: [
      /* @__PURE__ */ u$1("h2", { className: "section-title", children: "发币历史" }),
      /* @__PURE__ */ u$1("span", { className: "token-count", children: [
        tokens.length,
        " 个"
      ] })
    ] }),
    /* @__PURE__ */ u$1("div", { className: "filter-tabs", children: filterOptions.map((opt) => /* @__PURE__ */ u$1(
      "button",
      {
        className: `filter-tab ${filter === opt.key ? "active" : ""}`,
        onClick: () => setFilter(opt.key),
        children: opt.label
      },
      opt.key
    )) }),
    /* @__PURE__ */ u$1("div", { className: "token-list", children: filteredTokens.length === 0 ? /* @__PURE__ */ u$1("div", { className: "empty-list", children: "暂无符合条件的代币" }) : filteredTokens.map((token) => {
      const rugInfo = rugMap.get(token.mint);
      const dexInfo = dexMap.get(token.mint);
      return /* @__PURE__ */ u$1(
        TokenItem,
        {
          token,
          rugInfo,
          dexInfo,
          isExpanded: expanded === token.mint,
          onToggle: () => setExpanded(expanded === token.mint ? null : token.mint)
        },
        token.mint
      );
    }) })
  ] });
}
function TokenItem({ token, rugInfo, dexInfo, isExpanded, onToggle }) {
  const copyToClipboard = (text, e2) => {
    e2.stopPropagation();
    navigator.clipboard.writeText(text);
  };
  const getStatusBadge = () => {
    if (rugInfo) {
      return /* @__PURE__ */ u$1("span", { className: "badge badge-danger", children: rugInfo.rugType === "quick_dump" ? "快速清仓" : rugInfo.rugType === "lp_removal" ? "流动性移除" : "弃置" });
    }
    if (dexInfo == null ? void 0 : dexInfo.isListed) {
      return /* @__PURE__ */ u$1("span", { className: "badge badge-success", children: "已上外盘" });
    }
    return /* @__PURE__ */ u$1("span", { className: "badge badge-muted", children: "未上外盘" });
  };
  const displaySymbol = token.symbol === "???" ? shortenAddress(token.mint, 4) : token.symbol;
  const displayName = token.name === "未知" ? shortenAddress(token.mint, 6) : token.name;
  return /* @__PURE__ */ u$1("div", { className: `token-item ${rugInfo ? "rugged" : ""}`, children: [
    /* @__PURE__ */ u$1("div", { className: "token-main", onClick: onToggle, children: [
      /* @__PURE__ */ u$1("div", { className: "token-info", children: [
        /* @__PURE__ */ u$1("div", { className: "token-symbol", children: [
          "$",
          displaySymbol
        ] }),
        /* @__PURE__ */ u$1("div", { className: "token-name", title: token.mint, children: displayName })
      ] }),
      /* @__PURE__ */ u$1("div", { className: "token-meta", children: [
        getStatusBadge(),
        /* @__PURE__ */ u$1("span", { className: "token-time", children: formatRelativeTime(token.createdAt) })
      ] }),
      /* @__PURE__ */ u$1(
        "svg",
        {
          className: `expand-icon ${isExpanded ? "expanded" : ""}`,
          width: "16",
          height: "16",
          viewBox: "0 0 24 24",
          fill: "none",
          stroke: "currentColor",
          strokeWidth: "2",
          children: /* @__PURE__ */ u$1("polyline", { points: "6 9 12 15 18 9" })
        }
      )
    ] }),
    isExpanded && /* @__PURE__ */ u$1("div", { className: "token-details", children: [
      /* @__PURE__ */ u$1("div", { className: "detail-row", children: [
        /* @__PURE__ */ u$1("span", { className: "detail-label", children: "Mint:" }),
        /* @__PURE__ */ u$1(
          "a",
          {
            href: `https://solscan.io/token/${token.mint}`,
            target: "_blank",
            rel: "noopener noreferrer",
            className: "detail-value link",
            children: shortenAddress(token.mint, 8)
          }
        ),
        /* @__PURE__ */ u$1(
          "button",
          {
            className: "copy-btn",
            onClick: (e2) => copyToClipboard(token.mint, e2),
            title: "复制地址",
            children: "📋"
          }
        )
      ] }),
      (dexInfo == null ? void 0 : dexInfo.isListed) && /* @__PURE__ */ u$1(k$1, { children: [
        /* @__PURE__ */ u$1("div", { className: "detail-row", children: [
          /* @__PURE__ */ u$1("span", { className: "detail-label", children: "最高市值:" }),
          /* @__PURE__ */ u$1("span", { className: "detail-value", children: formatUSD(dexInfo.maxFdv) })
        ] }),
        /* @__PURE__ */ u$1("div", { className: "detail-row", children: [
          /* @__PURE__ */ u$1("span", { className: "detail-label", children: "当前流动性:" }),
          /* @__PURE__ */ u$1("span", { className: "detail-value", children: formatUSD(dexInfo.currentLiquidity) })
        ] }),
        /* @__PURE__ */ u$1("div", { className: "detail-row", children: [
          /* @__PURE__ */ u$1("span", { className: "detail-label", children: "24h 交易量:" }),
          /* @__PURE__ */ u$1("span", { className: "detail-value", children: formatUSD(dexInfo.volume24h) })
        ] })
      ] }),
      rugInfo && /* @__PURE__ */ u$1("div", { className: "rug-evidence", children: [
        /* @__PURE__ */ u$1("span", { className: "evidence-label", children: "风险证据:" }),
        /* @__PURE__ */ u$1("ul", { className: "evidence-list", children: rugInfo.evidence.map((e2, i2) => /* @__PURE__ */ u$1("li", { children: e2 }, i2)) })
      ] }),
      /* @__PURE__ */ u$1("div", { className: "detail-actions", children: [
        /* @__PURE__ */ u$1(
          "a",
          {
            href: `https://pump.fun/coin/${token.mint}`,
            target: "_blank",
            rel: "noopener noreferrer",
            className: "action-link",
            children: "Pump.fun"
          }
        ),
        /* @__PURE__ */ u$1(
          "a",
          {
            href: `https://dexscreener.com/solana/${token.mint}`,
            target: "_blank",
            rel: "noopener noreferrer",
            className: "action-link",
            children: "DexScreener"
          }
        ),
        /* @__PURE__ */ u$1(
          "a",
          {
            href: `https://gmgn.ai/sol/token/${token.mint}`,
            target: "_blank",
            rel: "noopener noreferrer",
            className: "action-link",
            children: "GMGN"
          }
        )
      ] })
    ] })
  ] });
}
function BundleWallets({ wallets }) {
  if (wallets.length === 0) return null;
  return /* @__PURE__ */ u$1("div", { className: "bundle-wallets-section", children: [
    /* @__PURE__ */ u$1("h2", { className: "section-title", children: [
      /* @__PURE__ */ u$1("svg", { width: "18", height: "18", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
        /* @__PURE__ */ u$1("path", { d: "M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2" }),
        /* @__PURE__ */ u$1("circle", { cx: "9", cy: "7", r: "4" }),
        /* @__PURE__ */ u$1("path", { d: "M23 21v-2a4 4 0 0 0-3-3.87" }),
        /* @__PURE__ */ u$1("path", { d: "M16 3.13a4 4 0 0 1 0 7.75" })
      ] }),
      "疑似捆绑钱包"
    ] }),
    /* @__PURE__ */ u$1("div", { className: "bundle-list", children: wallets.map((wallet, index) => /* @__PURE__ */ u$1("div", { className: "bundle-item", children: [
      /* @__PURE__ */ u$1("div", { className: "bundle-rank", children: [
        "#",
        index + 1
      ] }),
      /* @__PURE__ */ u$1("div", { className: "bundle-info", children: [
        /* @__PURE__ */ u$1(
          "a",
          {
            href: `https://solscan.io/account/${wallet.address}`,
            target: "_blank",
            rel: "noopener noreferrer",
            className: "bundle-address",
            children: shortenAddress(wallet.address, 6)
          }
        ),
        /* @__PURE__ */ u$1("div", { className: "bundle-evidence", children: wallet.evidence.map((e2, i2) => /* @__PURE__ */ u$1("span", { className: "evidence-tag", children: e2 }, i2)) })
      ] }),
      /* @__PURE__ */ u$1("div", { className: "bundle-confidence", children: [
        /* @__PURE__ */ u$1("div", { className: "confidence-bar", children: /* @__PURE__ */ u$1(
          "div",
          {
            className: "confidence-fill",
            style: {
              width: `${wallet.confidence}%`,
              backgroundColor: getConfidenceColor(wallet.confidence)
            }
          }
        ) }),
        /* @__PURE__ */ u$1("span", { className: "confidence-text", children: [
          wallet.confidence,
          "%"
        ] })
      ] })
    ] }, wallet.address)) }),
    /* @__PURE__ */ u$1("div", { className: "bundle-disclaimer", children: "* 捆绑钱包识别基于链上行为分析，仅供参考" })
  ] });
}
function getConfidenceColor(confidence) {
  if (confidence >= 80) return "#ef4444";
  if (confidence >= 60) return "#f97316";
  if (confidence >= 40) return "#eab308";
  return "#84cc16";
}
function LoadingState({ progress }) {
  return /* @__PURE__ */ u$1("div", { className: "loading-state", children: [
    /* @__PURE__ */ u$1("div", { className: "loading-spinner", children: [
      /* @__PURE__ */ u$1("div", { className: "spinner-ring" }),
      /* @__PURE__ */ u$1("div", { className: "spinner-ring" }),
      /* @__PURE__ */ u$1("div", { className: "spinner-ring" })
    ] }),
    /* @__PURE__ */ u$1("div", { className: "loading-info", children: [
      /* @__PURE__ */ u$1("div", { className: "loading-stage", children: progress.stage }),
      /* @__PURE__ */ u$1("div", { className: "loading-message", children: progress.message }),
      /* @__PURE__ */ u$1("div", { className: "progress-bar", children: /* @__PURE__ */ u$1(
        "div",
        {
          className: "progress-fill",
          style: { width: `${progress.progress}%` }
        }
      ) }),
      /* @__PURE__ */ u$1("div", { className: "progress-text", children: [
        progress.progress,
        "%"
      ] })
    ] }),
    /* @__PURE__ */ u$1("div", { className: "loading-tips", children: [
      /* @__PURE__ */ u$1("p", { children: "首次分析可能需要较长时间" }),
      /* @__PURE__ */ u$1("p", { children: "数据将被缓存以加速后续访问" })
    ] })
  ] });
}
function EmptyState({ onManualInput }) {
  return /* @__PURE__ */ u$1("div", { className: "empty-state", children: [
    /* @__PURE__ */ u$1("div", { className: "empty-icon", children: /* @__PURE__ */ u$1("svg", { width: "64", height: "64", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "1.5", children: [
      /* @__PURE__ */ u$1("circle", { cx: "11", cy: "11", r: "8" }),
      /* @__PURE__ */ u$1("path", { d: "m21 21-4.35-4.35" })
    ] }) }),
    /* @__PURE__ */ u$1("h2", { children: "未检测到 Dev 信息" }),
    /* @__PURE__ */ u$1("p", { className: "empty-description", children: "请在 GMGN 上打开某个代币页面，插件将自动检测 Dev 信息并开始分析。" }),
    /* @__PURE__ */ u$1("div", { className: "empty-divider", children: /* @__PURE__ */ u$1("span", { children: "或" }) }),
    /* @__PURE__ */ u$1("button", { className: "btn btn-primary", onClick: onManualInput, children: [
      /* @__PURE__ */ u$1("svg", { width: "18", height: "18", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
        /* @__PURE__ */ u$1("path", { d: "M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7" }),
        /* @__PURE__ */ u$1("path", { d: "M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z" })
      ] }),
      "手动输入 Dev 地址"
    ] }),
    /* @__PURE__ */ u$1("div", { className: "usage-tips", children: [
      /* @__PURE__ */ u$1("h3", { children: "使用说明" }),
      /* @__PURE__ */ u$1("ul", { children: [
        /* @__PURE__ */ u$1("li", { children: "1. 访问 gmgn.ai 并打开任意代币页面" }),
        /* @__PURE__ */ u$1("li", { children: "2. 插件会自动识别 Dev 钱包地址" }),
        /* @__PURE__ */ u$1("li", { children: "3. 点击插件图标打开侧边栏查看分析结果" }),
        /* @__PURE__ */ u$1("li", { children: "4. 或手动输入任意 Solana 钱包地址进行分析" })
      ] })
    ] })
  ] });
}
function ManualInput({ onAnalyze, onClose }) {
  const [address, setAddress] = d("");
  const [error, setError] = d("");
  const handleSubmit = (e2) => {
    e2.preventDefault();
    const trimmed = address.trim();
    if (!trimmed) {
      setError("请输入 Dev 钱包地址");
      return;
    }
    if (!isValidSolanaAddress(trimmed)) {
      setError("请输入有效的 Solana 钱包地址");
      return;
    }
    onAnalyze(trimmed);
  };
  const handleInputChange = (e2) => {
    const value = e2.target.value;
    setAddress(value);
    setError("");
  };
  return /* @__PURE__ */ u$1("div", { className: "modal-overlay", onClick: onClose, children: /* @__PURE__ */ u$1("div", { className: "modal-content", onClick: (e2) => e2.stopPropagation(), children: [
    /* @__PURE__ */ u$1("div", { className: "modal-header", children: [
      /* @__PURE__ */ u$1("h2", { children: "手动分析 Dev 地址" }),
      /* @__PURE__ */ u$1("button", { className: "btn btn-icon modal-close", onClick: onClose, children: /* @__PURE__ */ u$1("svg", { width: "20", height: "20", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
        /* @__PURE__ */ u$1("line", { x1: "18", y1: "6", x2: "6", y2: "18" }),
        /* @__PURE__ */ u$1("line", { x1: "6", y1: "6", x2: "18", y2: "18" })
      ] }) })
    ] }),
    /* @__PURE__ */ u$1("form", { onSubmit: handleSubmit, className: "modal-body", children: [
      /* @__PURE__ */ u$1("div", { className: "form-group", children: [
        /* @__PURE__ */ u$1("label", { htmlFor: "dev-address", children: "Dev 钱包地址" }),
        /* @__PURE__ */ u$1(
          "input",
          {
            id: "dev-address",
            type: "text",
            value: address,
            onInput: handleInputChange,
            placeholder: "输入 Solana 钱包地址...",
            className: error ? "input-error" : "",
            autoFocus: true
          }
        ),
        error && /* @__PURE__ */ u$1("div", { className: "error-message", children: error })
      ] }),
      /* @__PURE__ */ u$1("p", { className: "input-hint", children: "输入任意 Solana 钱包地址，将分析该地址的发币历史和行为特征" }),
      /* @__PURE__ */ u$1("div", { className: "modal-actions", children: [
        /* @__PURE__ */ u$1("button", { type: "button", className: "btn btn-secondary", onClick: onClose, children: "取消" }),
        /* @__PURE__ */ u$1("button", { type: "submit", className: "btn btn-primary", children: "开始分析" })
      ] })
    ] })
  ] }) });
}
function FundingSection({ fundingAnalysis }) {
  if (!fundingAnalysis || fundingAnalysis.sources.length === 0) {
    return null;
  }
  const formatSol = (amount) => {
    if (amount >= 1e3) {
      return `${(amount / 1e3).toFixed(2)}K SOL`;
    }
    return `${amount.toFixed(2)} SOL`;
  };
  const getSourceTypeLabel = (type, label) => {
    if (label) return label;
    switch (type) {
      case "cex":
        return "CEX";
      case "dex":
        return "DEX";
      case "wallet":
        return "钱包";
      default:
        return "未知";
    }
  };
  const getSourceTypeColor = (type) => {
    switch (type) {
      case "cex":
        return "#f97316";
      case "dex":
        return "#3b82f6";
      case "wallet":
        return "#6b7280";
      default:
        return "#6b7280";
    }
  };
  return /* @__PURE__ */ u$1("div", { className: "funding-section", children: [
    /* @__PURE__ */ u$1("div", { className: "section-header", children: [
      /* @__PURE__ */ u$1("h2", { className: "section-title", children: [
        /* @__PURE__ */ u$1("svg", { width: "18", height: "18", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: /* @__PURE__ */ u$1("path", { d: "M12 2v20M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6" }) }),
        "资金溯源"
      ] }),
      /* @__PURE__ */ u$1("span", { className: "funding-total", children: [
        "总入金: ",
        formatSol(fundingAnalysis.totalFunding)
      ] })
    ] }),
    fundingAnalysis.primarySource && /* @__PURE__ */ u$1("div", { className: "primary-source", children: [
      /* @__PURE__ */ u$1("div", { className: "primary-label", children: "主要资金来源" }),
      /* @__PURE__ */ u$1("div", { className: "primary-info", children: [
        /* @__PURE__ */ u$1(
          "a",
          {
            href: `https://solscan.io/account/${fundingAnalysis.primarySource.address}`,
            target: "_blank",
            rel: "noopener noreferrer",
            className: "source-address",
            children: shortenAddress(fundingAnalysis.primarySource.address, 6)
          }
        ),
        /* @__PURE__ */ u$1(
          "span",
          {
            className: "source-type-badge",
            style: { backgroundColor: getSourceTypeColor(fundingAnalysis.primarySource.type) },
            children: getSourceTypeLabel(fundingAnalysis.primarySource.type, fundingAnalysis.primarySource.label)
          }
        ),
        /* @__PURE__ */ u$1("span", { className: "source-amount", children: formatSol(fundingAnalysis.primarySource.amount) })
      ] })
    ] }),
    /* @__PURE__ */ u$1("div", { className: "funding-list", children: [
      /* @__PURE__ */ u$1("div", { className: "funding-list-header", children: "近期资金流入" }),
      fundingAnalysis.sources.slice(0, 5).map((source, index) => /* @__PURE__ */ u$1("div", { className: "funding-item", children: [
        /* @__PURE__ */ u$1("div", { className: "funding-item-left", children: [
          /* @__PURE__ */ u$1(
            "a",
            {
              href: `https://solscan.io/account/${source.address}`,
              target: "_blank",
              rel: "noopener noreferrer",
              className: "funding-address",
              children: shortenAddress(source.address, 4)
            }
          ),
          /* @__PURE__ */ u$1(
            "span",
            {
              className: "funding-type",
              style: { color: getSourceTypeColor(source.type) },
              children: getSourceTypeLabel(source.type, source.label)
            }
          )
        ] }),
        /* @__PURE__ */ u$1("div", { className: "funding-item-right", children: [
          /* @__PURE__ */ u$1("span", { className: "funding-amount", children: [
            "+",
            source.amount.toFixed(2),
            " SOL"
          ] }),
          /* @__PURE__ */ u$1("span", { className: "funding-time", children: formatRelativeTime(source.timestamp) })
        ] })
      ] }, index))
    ] }),
    fundingAnalysis.firstFundingTime > 0 && /* @__PURE__ */ u$1("div", { className: "funding-footer", children: [
      "首次入金: ",
      formatRelativeTime(fundingAnalysis.firstFundingTime)
    ] })
  ] });
}
function HoldingsSection({ holdingsAnalysis }) {
  if (!holdingsAnalysis) {
    return null;
  }
  const formatBalance = (balance) => {
    if (balance >= 1e6) {
      return `${(balance / 1e6).toFixed(2)}M`;
    }
    if (balance >= 1e3) {
      return `${(balance / 1e3).toFixed(2)}K`;
    }
    return balance.toFixed(2);
  };
  return /* @__PURE__ */ u$1("div", { className: "holdings-section", children: [
    /* @__PURE__ */ u$1("div", { className: "section-header", children: [
      /* @__PURE__ */ u$1("h2", { className: "section-title", children: [
        /* @__PURE__ */ u$1("svg", { width: "18", height: "18", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
          /* @__PURE__ */ u$1("rect", { x: "2", y: "7", width: "20", height: "14", rx: "2", ry: "2" }),
          /* @__PURE__ */ u$1("path", { d: "M16 21V5a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v16" })
        ] }),
        "当前持仓"
      ] }),
      /* @__PURE__ */ u$1("span", { className: "holdings-total", children: [
        "总价值: ",
        formatUSD(holdingsAnalysis.totalValueUsd)
      ] })
    ] }),
    /* @__PURE__ */ u$1("div", { className: "holdings-sol", children: [
      /* @__PURE__ */ u$1("div", { className: "sol-icon", children: /* @__PURE__ */ u$1("svg", { width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", children: [
        /* @__PURE__ */ u$1("circle", { cx: "12", cy: "12", r: "10", fill: "#14F195", fillOpacity: "0.2" }),
        /* @__PURE__ */ u$1("circle", { cx: "12", cy: "12", r: "6", fill: "#14F195" })
      ] }) }),
      /* @__PURE__ */ u$1("div", { className: "sol-info", children: [
        /* @__PURE__ */ u$1("span", { className: "sol-amount", children: [
          holdingsAnalysis.solBalance.toFixed(4),
          " SOL"
        ] }),
        /* @__PURE__ */ u$1("span", { className: "sol-value", children: formatUSD(holdingsAnalysis.solBalance * 200) })
      ] })
    ] }),
    holdingsAnalysis.tokenHoldings.length > 0 && /* @__PURE__ */ u$1("div", { className: "token-holdings", children: [
      /* @__PURE__ */ u$1("div", { className: "holdings-list-header", children: "代币持仓" }),
      holdingsAnalysis.tokenHoldings.map((token, index) => /* @__PURE__ */ u$1("div", { className: "holding-item", children: [
        /* @__PURE__ */ u$1("div", { className: "holding-left", children: [
          /* @__PURE__ */ u$1("span", { className: "holding-symbol", children: [
            "$",
            token.symbol
          ] }),
          /* @__PURE__ */ u$1(
            "a",
            {
              href: `https://solscan.io/token/${token.mint}`,
              target: "_blank",
              rel: "noopener noreferrer",
              className: "holding-mint",
              children: shortenAddress(token.mint, 4)
            }
          )
        ] }),
        /* @__PURE__ */ u$1("div", { className: "holding-right", children: [
          /* @__PURE__ */ u$1("span", { className: "holding-balance", children: formatBalance(token.balance) }),
          /* @__PURE__ */ u$1("span", { className: "holding-value", children: formatUSD(token.valueUsd) })
        ] })
      ] }, index))
    ] }),
    holdingsAnalysis.tokenHoldings.length === 0 && /* @__PURE__ */ u$1("div", { className: "no-holdings", children: "暂无代币持仓" })
  ] });
}
function AdvancedStats({ rugAnalysis, dexAnalysis, socialInfo }) {
  const formatDuration2 = (ms) => {
    if (!ms) return "-";
    const minutes = Math.floor(ms / 6e4);
    const hours = Math.floor(ms / 36e5);
    const days = Math.floor(ms / 864e5);
    if (days > 0) return `${days} 天`;
    if (hours > 0) return `${hours} 小时`;
    return `${minutes} 分钟`;
  };
  const hasRugData = rugAnalysis.avgRugSpeed !== void 0;
  const hasSurvivalData = dexAnalysis.avgSurvivalTime !== void 0;
  return /* @__PURE__ */ u$1("div", { className: "advanced-stats", children: [
    hasRugData && /* @__PURE__ */ u$1("div", { className: "stat-block rug-speed-block", children: [
      /* @__PURE__ */ u$1("div", { className: "stat-block-header", children: [
        /* @__PURE__ */ u$1("svg", { width: "18", height: "18", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
          /* @__PURE__ */ u$1("circle", { cx: "12", cy: "12", r: "10" }),
          /* @__PURE__ */ u$1("polyline", { points: "12 6 12 12 16 14" })
        ] }),
        /* @__PURE__ */ u$1("h3", { children: "Rug 速度分析" })
      ] }),
      /* @__PURE__ */ u$1("div", { className: "stat-block-content", children: [
        /* @__PURE__ */ u$1("div", { className: "speed-stat", children: [
          /* @__PURE__ */ u$1("span", { className: "speed-label", children: "平均 Rug 速度" }),
          /* @__PURE__ */ u$1("span", { className: "speed-value danger", children: formatDuration2(rugAnalysis.avgRugSpeed) })
        ] }),
        /* @__PURE__ */ u$1("div", { className: "speed-stat", children: [
          /* @__PURE__ */ u$1("span", { className: "speed-label", children: "最快 Rug" }),
          /* @__PURE__ */ u$1("span", { className: "speed-value", children: formatDuration2(rugAnalysis.fastestRug) })
        ] }),
        /* @__PURE__ */ u$1("div", { className: "speed-stat", children: [
          /* @__PURE__ */ u$1("span", { className: "speed-label", children: "最慢 Rug" }),
          /* @__PURE__ */ u$1("span", { className: "speed-value", children: formatDuration2(rugAnalysis.slowestRug) })
        ] })
      ] }),
      rugAnalysis.avgRugSpeed && rugAnalysis.avgRugSpeed < 24 * 60 * 60 * 1e3 && /* @__PURE__ */ u$1("div", { className: "warning-badge", children: [
        /* @__PURE__ */ u$1("svg", { width: "14", height: "14", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
          /* @__PURE__ */ u$1("path", { d: "M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z" }),
          /* @__PURE__ */ u$1("line", { x1: "12", y1: "9", x2: "12", y2: "13" }),
          /* @__PURE__ */ u$1("line", { x1: "12", y1: "17", x2: "12.01", y2: "17" })
        ] }),
        "快速 Rug 风险"
      ] })
    ] }),
    hasSurvivalData && /* @__PURE__ */ u$1("div", { className: "stat-block survival-block", children: [
      /* @__PURE__ */ u$1("div", { className: "stat-block-header", children: [
        /* @__PURE__ */ u$1("svg", { width: "18", height: "18", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: /* @__PURE__ */ u$1("path", { d: "M22 12h-4l-3 9L9 3l-3 9H2" }) }),
        /* @__PURE__ */ u$1("h3", { children: "代币存活分析" })
      ] }),
      /* @__PURE__ */ u$1("div", { className: "stat-block-content", children: [
        /* @__PURE__ */ u$1("div", { className: "survival-stat", children: [
          /* @__PURE__ */ u$1("span", { className: "survival-label", children: "平均存活时间" }),
          /* @__PURE__ */ u$1("span", { className: "survival-value", children: formatDuration2(dexAnalysis.avgSurvivalTime) })
        ] }),
        /* @__PURE__ */ u$1("div", { className: "survival-bar", children: [
          /* @__PURE__ */ u$1("div", { className: "survival-segment alive", style: {
            width: `${(dexAnalysis.aliveCount || 0) / (dexAnalysis.totalTokens || 1) * 100}%`
          }, children: /* @__PURE__ */ u$1("span", { children: [
            dexAnalysis.aliveCount || 0,
            " 存活"
          ] }) }),
          /* @__PURE__ */ u$1("div", { className: "survival-segment dead", style: {
            width: `${(dexAnalysis.deadCount || 0) / (dexAnalysis.totalTokens || 1) * 100}%`
          }, children: /* @__PURE__ */ u$1("span", { children: [
            dexAnalysis.deadCount || 0,
            " 死亡"
          ] }) })
        ] }),
        /* @__PURE__ */ u$1("div", { className: "survival-legend", children: [
          /* @__PURE__ */ u$1("span", { className: "legend-item", children: [
            /* @__PURE__ */ u$1("span", { className: "legend-dot alive" }),
            "存活 (",
            ((dexAnalysis.aliveCount || 0) / (dexAnalysis.totalTokens || 1) * 100).toFixed(0),
            "%)"
          ] }),
          /* @__PURE__ */ u$1("span", { className: "legend-item", children: [
            /* @__PURE__ */ u$1("span", { className: "legend-dot dead" }),
            "死亡 (",
            ((dexAnalysis.deadCount || 0) / (dexAnalysis.totalTokens || 1) * 100).toFixed(0),
            "%)"
          ] })
        ] })
      ] })
    ] }),
    rugAnalysis.estimatedRugProfits !== void 0 && rugAnalysis.estimatedRugProfits > 0 && /* @__PURE__ */ u$1("div", { className: "stat-block profit-block", children: [
      /* @__PURE__ */ u$1("div", { className: "stat-block-header", children: [
        /* @__PURE__ */ u$1("svg", { width: "18", height: "18", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
          /* @__PURE__ */ u$1("line", { x1: "12", y1: "1", x2: "12", y2: "23" }),
          /* @__PURE__ */ u$1("path", { d: "M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6" })
        ] }),
        /* @__PURE__ */ u$1("h3", { children: "估算 Rug 收益" })
      ] }),
      /* @__PURE__ */ u$1("div", { className: "profit-amount", children: formatUSD(rugAnalysis.estimatedRugProfits) }),
      /* @__PURE__ */ u$1("div", { className: "profit-note", children: "基于历史代币最高市值估算（仅供参考）" })
    ] }),
    socialInfo && Object.keys(socialInfo).length > 0 && /* @__PURE__ */ u$1("div", { className: "stat-block social-block", children: [
      /* @__PURE__ */ u$1("div", { className: "stat-block-header", children: [
        /* @__PURE__ */ u$1("svg", { width: "18", height: "18", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
          /* @__PURE__ */ u$1("path", { d: "M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z" }),
          /* @__PURE__ */ u$1("polyline", { points: "22,6 12,13 2,6" })
        ] }),
        /* @__PURE__ */ u$1("h3", { children: "社交关联" })
      ] }),
      /* @__PURE__ */ u$1("div", { className: "social-links", children: [
        socialInfo.twitter && /* @__PURE__ */ u$1(
          "a",
          {
            href: socialInfo.twitter,
            target: "_blank",
            rel: "noopener noreferrer",
            className: "social-link twitter",
            children: [
              /* @__PURE__ */ u$1("svg", { width: "16", height: "16", viewBox: "0 0 24 24", fill: "currentColor", children: /* @__PURE__ */ u$1("path", { d: "M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z" }) }),
              "Twitter"
            ]
          }
        ),
        socialInfo.telegram && /* @__PURE__ */ u$1(
          "a",
          {
            href: socialInfo.telegram,
            target: "_blank",
            rel: "noopener noreferrer",
            className: "social-link telegram",
            children: [
              /* @__PURE__ */ u$1("svg", { width: "16", height: "16", viewBox: "0 0 24 24", fill: "currentColor", children: /* @__PURE__ */ u$1("path", { d: "M11.944 0A12 12 0 0 0 0 12a12 12 0 0 0 12 12 12 12 0 0 0 12-12A12 12 0 0 0 12 0a12 12 0 0 0-.056 0zm4.962 7.224c.1-.002.321.023.465.14a.506.506 0 0 1 .171.325c.016.093.036.306.02.472-.18 1.898-.962 6.502-1.36 8.627-.168.9-.499 1.201-.82 1.23-.696.065-1.225-.46-1.9-.902-1.056-.693-1.653-1.124-2.678-1.8-1.185-.78-.417-1.21.258-1.91.177-.184 3.247-2.977 3.307-3.23.007-.032.014-.15-.056-.212s-.174-.041-.249-.024c-.106.024-1.793 1.14-5.061 3.345-.48.33-.913.49-1.302.48-.428-.008-1.252-.241-1.865-.44-.752-.245-1.349-.374-1.297-.789.027-.216.325-.437.893-.663 3.498-1.524 5.83-2.529 6.998-3.014 3.332-1.386 4.025-1.627 4.476-1.635z" }) }),
              "Telegram"
            ]
          }
        ),
        socialInfo.website && /* @__PURE__ */ u$1(
          "a",
          {
            href: socialInfo.website,
            target: "_blank",
            rel: "noopener noreferrer",
            className: "social-link website",
            children: [
              /* @__PURE__ */ u$1("svg", { width: "16", height: "16", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
                /* @__PURE__ */ u$1("circle", { cx: "12", cy: "12", r: "10" }),
                /* @__PURE__ */ u$1("line", { x1: "2", y1: "12", x2: "22", y2: "12" }),
                /* @__PURE__ */ u$1("path", { d: "M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z" })
              ] }),
              "Website"
            ]
          }
        ),
        socialInfo.discord && /* @__PURE__ */ u$1(
          "a",
          {
            href: socialInfo.discord,
            target: "_blank",
            rel: "noopener noreferrer",
            className: "social-link discord",
            children: [
              /* @__PURE__ */ u$1("svg", { width: "16", height: "16", viewBox: "0 0 24 24", fill: "currentColor", children: /* @__PURE__ */ u$1("path", { d: "M20.317 4.3698a19.7913 19.7913 0 00-4.8851-1.5152.0741.0741 0 00-.0785.0371c-.211.3753-.4447.8648-.6083 1.2495-1.8447-.2762-3.68-.2762-5.4868 0-.1636-.3933-.4058-.8742-.6177-1.2495a.077.077 0 00-.0785-.037 19.7363 19.7363 0 00-4.8852 1.515.0699.0699 0 00-.0321.0277C.5334 9.0458-.319 13.5799.0992 18.0578a.0824.0824 0 00.0312.0561c2.0528 1.5076 4.0413 2.4228 5.9929 3.0294a.0777.0777 0 00.0842-.0276c.4616-.6304.8731-1.2952 1.226-1.9942a.076.076 0 00-.0416-.1057c-.6528-.2476-1.2743-.5495-1.8722-.8923a.077.077 0 01-.0076-.1277c.1258-.0943.2517-.1923.3718-.2914a.0743.0743 0 01.0776-.0105c3.9278 1.7933 8.18 1.7933 12.0614 0a.0739.0739 0 01.0785.0095c.1202.099.246.1981.3728.2924a.077.077 0 01-.0066.1276 12.2986 12.2986 0 01-1.873.8914.0766.0766 0 00-.0407.1067c.3604.698.7719 1.3628 1.225 1.9932a.076.076 0 00.0842.0286c1.961-.6067 3.9495-1.5219 6.0023-3.0294a.077.077 0 00.0313-.0552c.5004-5.177-.8382-9.6739-3.5485-13.6604a.061.061 0 00-.0312-.0286zM8.02 15.3312c-1.1825 0-2.1569-1.0857-2.1569-2.419 0-1.3332.9555-2.4189 2.157-2.4189 1.2108 0 2.1757 1.0952 2.1568 2.419 0 1.3332-.9555 2.4189-2.1569 2.4189zm7.9748 0c-1.1825 0-2.1569-1.0857-2.1569-2.419 0-1.3332.9554-2.4189 2.1569-2.4189 1.2108 0 2.1757 1.0952 2.1568 2.419 0 1.3332-.946 2.4189-2.1568 2.4189Z" }) }),
              "Discord"
            ]
          }
        )
      ] })
    ] })
  ] });
}
function HistoryPanel({ onClose, onSelect }) {
  const [history, setHistory] = d([]);
  const [loading, setLoading] = d(true);
  y(() => {
    loadHistory();
  }, []);
  const loadHistory = async () => {
    try {
      const result = await chrome.runtime.sendMessage({ type: "GET_HISTORY" });
      setHistory(result || []);
    } catch (e2) {
      console.error("加载历史记录失败:", e2);
    } finally {
      setLoading(false);
    }
  };
  const handleSelect = (address) => {
    onSelect(address);
    onClose();
  };
  return /* @__PURE__ */ u$1("div", { className: "modal-overlay", onClick: onClose, children: /* @__PURE__ */ u$1("div", { className: "modal-content history-modal", onClick: (e2) => e2.stopPropagation(), children: [
    /* @__PURE__ */ u$1("div", { className: "modal-header", children: [
      /* @__PURE__ */ u$1("h2", { children: "历史记录" }),
      /* @__PURE__ */ u$1("button", { className: "modal-close", onClick: onClose, children: /* @__PURE__ */ u$1("svg", { width: "20", height: "20", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
        /* @__PURE__ */ u$1("line", { x1: "18", y1: "6", x2: "6", y2: "18" }),
        /* @__PURE__ */ u$1("line", { x1: "6", y1: "6", x2: "18", y2: "18" })
      ] }) })
    ] }),
    /* @__PURE__ */ u$1("div", { className: "modal-body history-body", children: [
      loading && /* @__PURE__ */ u$1("div", { className: "history-loading", children: "加载中..." }),
      !loading && history.length === 0 && /* @__PURE__ */ u$1("div", { className: "history-empty", children: [
        /* @__PURE__ */ u$1("svg", { width: "48", height: "48", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "1.5", children: [
          /* @__PURE__ */ u$1("circle", { cx: "12", cy: "12", r: "10" }),
          /* @__PURE__ */ u$1("polyline", { points: "12 6 12 12 16 14" })
        ] }),
        /* @__PURE__ */ u$1("p", { children: "暂无历史记录" }),
        /* @__PURE__ */ u$1("span", { children: "分析过的 Dev 会显示在这里" })
      ] }),
      !loading && history.length > 0 && /* @__PURE__ */ u$1("div", { className: "history-list", children: history.map((entry, index) => /* @__PURE__ */ u$1(
        "div",
        {
          className: "history-item",
          onClick: () => handleSelect(entry.devAddress),
          children: [
            /* @__PURE__ */ u$1("div", { className: "history-item-left", children: [
              /* @__PURE__ */ u$1(
                "div",
                {
                  className: "history-grade",
                  style: { backgroundColor: GRADE_COLORS[entry.grade] || "#6b7280" },
                  children: entry.grade
                }
              ),
              /* @__PURE__ */ u$1("div", { className: "history-info", children: [
                /* @__PURE__ */ u$1("div", { className: "history-address", children: shortenAddress(entry.devAddress, 6) }),
                /* @__PURE__ */ u$1("div", { className: "history-meta", children: [
                  /* @__PURE__ */ u$1(
                    "span",
                    {
                      className: "history-label",
                      style: { color: LABEL_COLORS[entry.label] || "#6b7280" },
                      children: entry.label
                    }
                  ),
                  /* @__PURE__ */ u$1("span", { className: "history-tokens", children: [
                    entry.tokenCount,
                    " 个代币"
                  ] })
                ] })
              ] })
            ] }),
            /* @__PURE__ */ u$1("div", { className: "history-item-right", children: [
              /* @__PURE__ */ u$1("div", { className: "history-score", children: entry.score }),
              /* @__PURE__ */ u$1("div", { className: "history-time", children: formatRelativeTime(entry.analyzedAt) })
            ] })
          ]
        },
        index
      )) })
    ] })
  ] }) });
}
function SettingsPanel({ onClose }) {
  const [config, setConfig] = d(DEFAULT_CONFIG);
  const [saved, setSaved] = d(false);
  y(() => {
    loadConfig();
  }, []);
  const loadConfig = async () => {
    try {
      const result = await chrome.storage.local.get("user_config");
      if (result.user_config) {
        setConfig({ ...DEFAULT_CONFIG, ...result.user_config });
      }
    } catch (e2) {
      console.error("加载配置失败:", e2);
    }
  };
  const saveConfig = async () => {
    try {
      await chrome.storage.local.set({ user_config: config });
      setSaved(true);
      setTimeout(() => setSaved(false), 2e3);
    } catch (e2) {
      console.error("保存配置失败:", e2);
    }
  };
  const updateConfig = (key, value) => {
    setConfig((prev) => ({ ...prev, [key]: value }));
  };
  return /* @__PURE__ */ u$1("div", { className: "modal-overlay", onClick: onClose, children: /* @__PURE__ */ u$1("div", { className: "modal-content settings-modal", onClick: (e2) => e2.stopPropagation(), children: [
    /* @__PURE__ */ u$1("div", { className: "modal-header", children: [
      /* @__PURE__ */ u$1("h2", { children: "设置" }),
      /* @__PURE__ */ u$1("button", { className: "modal-close", onClick: onClose, children: /* @__PURE__ */ u$1("svg", { width: "20", height: "20", viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", strokeWidth: "2", children: [
        /* @__PURE__ */ u$1("line", { x1: "18", y1: "6", x2: "6", y2: "18" }),
        /* @__PURE__ */ u$1("line", { x1: "6", y1: "6", x2: "18", y2: "18" })
      ] }) })
    ] }),
    /* @__PURE__ */ u$1("div", { className: "modal-body settings-body", children: [
      /* @__PURE__ */ u$1("div", { className: "settings-section", children: [
        /* @__PURE__ */ u$1("h3", { children: "分析参数" }),
        /* @__PURE__ */ u$1("div", { className: "settings-item", children: [
          /* @__PURE__ */ u$1("div", { className: "settings-label", children: [
            /* @__PURE__ */ u$1("span", { children: "最大分析代币数" }),
            /* @__PURE__ */ u$1("span", { className: "settings-hint", children: "影响分析速度和完整性" })
          ] }),
          /* @__PURE__ */ u$1("div", { className: "settings-control", children: [
            /* @__PURE__ */ u$1(
              "input",
              {
                type: "range",
                min: "10",
                max: "100",
                step: "10",
                value: config.maxTokensToAnalyze,
                onChange: (e2) => updateConfig("maxTokensToAnalyze", parseInt(e2.currentTarget.value))
              }
            ),
            /* @__PURE__ */ u$1("span", { className: "settings-value", children: config.maxTokensToAnalyze })
          ] })
        ] }),
        /* @__PURE__ */ u$1("div", { className: "settings-item", children: [
          /* @__PURE__ */ u$1("div", { className: "settings-label", children: [
            /* @__PURE__ */ u$1("span", { children: "缓存过期时间（小时）" }),
            /* @__PURE__ */ u$1("span", { className: "settings-hint", children: "数据自动刷新间隔" })
          ] }),
          /* @__PURE__ */ u$1("div", { className: "settings-control", children: [
            /* @__PURE__ */ u$1(
              "input",
              {
                type: "range",
                min: "1",
                max: "48",
                step: "1",
                value: config.cacheExpiry,
                onChange: (e2) => updateConfig("cacheExpiry", parseInt(e2.currentTarget.value))
              }
            ),
            /* @__PURE__ */ u$1("span", { className: "settings-value", children: [
              config.cacheExpiry,
              "h"
            ] })
          ] })
        ] })
      ] }),
      /* @__PURE__ */ u$1("div", { className: "settings-section", children: [
        /* @__PURE__ */ u$1("h3", { children: "风险提示阈值" }),
        /* @__PURE__ */ u$1("div", { className: "settings-item", children: [
          /* @__PURE__ */ u$1("div", { className: "settings-label", children: [
            /* @__PURE__ */ u$1("span", { children: "Rug 率警告阈值" }),
            /* @__PURE__ */ u$1("span", { className: "settings-hint", children: "超过此比例时高亮警告" })
          ] }),
          /* @__PURE__ */ u$1("div", { className: "settings-control", children: [
            /* @__PURE__ */ u$1(
              "input",
              {
                type: "range",
                min: "0.1",
                max: "0.8",
                step: "0.1",
                value: config.rugRatioWarningThreshold,
                onChange: (e2) => updateConfig("rugRatioWarningThreshold", parseFloat(e2.currentTarget.value))
              }
            ),
            /* @__PURE__ */ u$1("span", { className: "settings-value", children: [
              Math.round(config.rugRatioWarningThreshold * 100),
              "%"
            ] })
          ] })
        ] }),
        /* @__PURE__ */ u$1("div", { className: "settings-item", children: [
          /* @__PURE__ */ u$1("div", { className: "settings-label", children: [
            /* @__PURE__ */ u$1("span", { children: "捆绑钱包警告阈值" }),
            /* @__PURE__ */ u$1("span", { className: "settings-hint", children: "超过此数量时高亮警告" })
          ] }),
          /* @__PURE__ */ u$1("div", { className: "settings-control", children: [
            /* @__PURE__ */ u$1(
              "input",
              {
                type: "range",
                min: "1",
                max: "10",
                step: "1",
                value: config.bundleWalletWarningThreshold,
                onChange: (e2) => updateConfig("bundleWalletWarningThreshold", parseInt(e2.currentTarget.value))
              }
            ),
            /* @__PURE__ */ u$1("span", { className: "settings-value", children: config.bundleWalletWarningThreshold })
          ] })
        ] })
      ] }),
      /* @__PURE__ */ u$1("div", { className: "settings-section", children: [
        /* @__PURE__ */ u$1("h3", { children: "高级设置" }),
        /* @__PURE__ */ u$1("div", { className: "settings-item vertical", children: [
          /* @__PURE__ */ u$1("div", { className: "settings-label", children: [
            /* @__PURE__ */ u$1("span", { children: "自定义 RPC 端点（可选）" }),
            /* @__PURE__ */ u$1("span", { className: "settings-hint", children: "留空使用默认公共 RPC" })
          ] }),
          /* @__PURE__ */ u$1(
            "input",
            {
              type: "text",
              className: "settings-input",
              placeholder: "https://api.mainnet-beta.solana.com",
              value: config.customRpcEndpoint || "",
              onChange: (e2) => updateConfig("customRpcEndpoint", e2.currentTarget.value)
            }
          )
        ] })
      ] })
    ] }),
    /* @__PURE__ */ u$1("div", { className: "modal-footer", children: [
      saved && /* @__PURE__ */ u$1("span", { className: "save-success", children: "已保存" }),
      /* @__PURE__ */ u$1("button", { className: "btn btn-secondary", onClick: onClose, children: "取消" }),
      /* @__PURE__ */ u$1("button", { className: "btn btn-primary", onClick: saveConfig, children: "保存设置" })
    ] })
  ] }) });
}
function App() {
  const [analysis, setAnalysis] = d(null);
  const [isLoading, setIsLoading] = d(false);
  const [progress, setProgress] = d(null);
  const [currentDev, setCurrentDev] = d(null);
  const [showManualInput, setShowManualInput] = d(false);
  const [showHistory, setShowHistory] = d(false);
  const [showSettings, setShowSettings] = d(false);
  const requestDetection = q(async () => {
    var _a;
    try {
      const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
      if ((tab == null ? void 0 : tab.id) && ((_a = tab.url) == null ? void 0 : _a.includes("gmgn.ai"))) {
        chrome.tabs.sendMessage(tab.id, { type: "REQUEST_DETECTION" }).catch(() => {
          console.log("[Sidepanel] Content script 未响应，可能未加载");
        });
      }
    } catch (err) {
      console.error("[Sidepanel] 请求检测失败:", err);
    }
  }, []);
  y(() => {
    console.log("[Sidepanel] App 初始化");
    chrome.runtime.sendMessage({ type: "GET_CURRENT_DEV" }).then((response) => {
      console.log("[Sidepanel] 获取当前 Dev:", response);
      if (response == null ? void 0 : response.devAddress) {
        setCurrentDev(response.devAddress);
        if (response.analysis) {
          setAnalysis(response.analysis);
        }
      }
    }).catch(console.error);
    requestDetection();
    const handleMessage = (message) => {
      console.log("[Sidepanel] 收到消息:", message.type);
      switch (message.type) {
        case "DEV_INFO_DETECTED":
          const devInfo = message.payload;
          console.log("[Sidepanel] 检测到 Dev:", devInfo);
          setCurrentDev(devInfo.devAddress);
          startAnalysis(devInfo.devAddress, devInfo.fundingSource, devInfo.tokenMint);
          break;
        case "ANALYSIS_PROGRESS":
          const progressInfo = message.payload;
          setProgress(progressInfo);
          break;
        case "ANALYSIS_RESULT":
          setAnalysis(message.payload);
          setIsLoading(false);
          setProgress(null);
          break;
      }
    };
    chrome.runtime.onMessage.addListener(handleMessage);
    const handleTabUpdate = (_tabId, changeInfo) => {
      var _a;
      if ((_a = changeInfo.url) == null ? void 0 : _a.includes("gmgn.ai")) {
        console.log("[Sidepanel] 检测到 GMGN 标签页 URL 变化");
        setTimeout(requestDetection, 1500);
      }
    };
    chrome.tabs.onUpdated.addListener(handleTabUpdate);
    return () => {
      chrome.runtime.onMessage.removeListener(handleMessage);
      chrome.tabs.onUpdated.removeListener(handleTabUpdate);
    };
  }, [requestDetection]);
  const startAnalysis = async (devAddress, fundingSource, tokenMint, forceRefresh) => {
    setIsLoading(true);
    setProgress({ stage: "初始化", progress: 0, message: forceRefresh ? "强制刷新中..." : "正在开始分析..." });
    try {
      const result = await chrome.runtime.sendMessage({
        type: "ANALYZE_DEV",
        payload: { devAddress, fundingSource, tokenMint, forceRefresh }
      });
      console.log("[Sidepanel] 分析结果:", result);
      setAnalysis(result);
    } catch (error) {
      console.error("[Sidepanel] 分析失败:", error);
    } finally {
      setIsLoading(false);
      setProgress(null);
    }
  };
  const handleManualAnalyze = (address) => {
    setCurrentDev(address);
    setShowManualInput(false);
    startAnalysis(address, void 0, void 0, true);
  };
  const handleRefresh = () => {
    if (currentDev) {
      startAnalysis(currentDev, void 0, void 0, true);
    }
  };
  const handleClearCache = async () => {
    try {
      await chrome.runtime.sendMessage({ type: "CLEAR_CACHE" });
      setAnalysis(null);
      alert("缓存已清除");
    } catch (e2) {
      console.error("清除缓存失败:", e2);
    }
  };
  const handleHistorySelect = (address) => {
    setCurrentDev(address);
    startAnalysis(address, void 0, void 0, true);
  };
  return /* @__PURE__ */ u$1("div", { className: "app", children: [
    /* @__PURE__ */ u$1(
      Header,
      {
        onManualInput: () => setShowManualInput(true),
        onRefresh: handleRefresh,
        onClearCache: handleClearCache,
        onShowHistory: () => setShowHistory(true),
        onShowSettings: () => setShowSettings(true),
        isLoading
      }
    ),
    showManualInput && /* @__PURE__ */ u$1(
      ManualInput,
      {
        onAnalyze: handleManualAnalyze,
        onClose: () => setShowManualInput(false)
      }
    ),
    showHistory && /* @__PURE__ */ u$1(
      HistoryPanel,
      {
        onClose: () => setShowHistory(false),
        onSelect: handleHistorySelect
      }
    ),
    showSettings && /* @__PURE__ */ u$1(
      SettingsPanel,
      {
        onClose: () => setShowSettings(false)
      }
    ),
    /* @__PURE__ */ u$1("main", { className: "main-content", children: [
      isLoading && progress && /* @__PURE__ */ u$1(LoadingState, { progress }),
      !isLoading && !analysis && !currentDev && /* @__PURE__ */ u$1(EmptyState, { onManualInput: () => setShowManualInput(true) }),
      analysis && !isLoading && /* @__PURE__ */ u$1(k$1, { children: [
        /* @__PURE__ */ u$1(
          ScoreCard,
          {
            devAddress: analysis.devAddress,
            score: analysis.score,
            analyzedAt: analysis.analyzedAt,
            error: analysis.error
          }
        ),
        /* @__PURE__ */ u$1(
          StatsSection,
          {
            cluster: analysis.cluster,
            rugAnalysis: analysis.rugAnalysis,
            dexAnalysis: analysis.dexAnalysis
          }
        ),
        /* @__PURE__ */ u$1(
          AdvancedStats,
          {
            rugAnalysis: analysis.rugAnalysis,
            dexAnalysis: analysis.dexAnalysis,
            socialInfo: analysis.socialInfo
          }
        ),
        /* @__PURE__ */ u$1(FundingSection, { fundingAnalysis: analysis.fundingAnalysis }),
        /* @__PURE__ */ u$1(HoldingsSection, { holdingsAnalysis: analysis.holdingsAnalysis }),
        analysis.cluster.bundleWallets.length > 0 && /* @__PURE__ */ u$1(BundleWallets, { wallets: analysis.cluster.bundleWallets }),
        /* @__PURE__ */ u$1(
          TokenList,
          {
            tokens: analysis.cluster.tokensCreated,
            rugTokens: analysis.rugAnalysis.rugTokens,
            dexTokens: analysis.dexAnalysis.tokens
          }
        )
      ] })
    ] })
  ] });
}
G(/* @__PURE__ */ u$1(App, {}), document.getElementById("app"));
